/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp;

import java.util.Map;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.core.options.Descriptor;

public abstract class CacheableGPGraphNode<T>
implements GPGraphNode<T> {
    private boolean cached = false;
    private T cachedValue = null;

    @Override
    public T execute() {
        if (!this.cached) {
            return this.calculateValue();
        }
        if (this.cachedValue == null) {
            this.cachedValue = this.calculateValue();
        }
        return this.cachedValue;
    }

    @Override
    public boolean setOptions(Map<String, Descriptor> options) {
        for (Map.Entry<String, Descriptor> entry : options.entrySet()) {
            if (this.setOption(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public abstract T calculateValue();

    @Override
    public abstract T simpleReturnType();

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public T getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(T cachedValue) {
        this.cachedValue = cachedValue;
    }
}

