/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.ga.selector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import science.aist.machinelearning.algorithm.ga.Selector;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.options.Descriptor;

public class TournamentSelector<GT, PT>
implements Selector<GT, PT>,
Configurable {
    private static final Logger logger = Logger.getLogger(TournamentSelector.class);
    private final Random r = new Random();
    private int tournamentSize = 2;

    @Override
    public Solution<GT, PT> select(List<Solution<GT, PT>> population) {
        if (population == null || population.size() == 0) {
            return null;
        }
        logger.trace((Object)"Starting tournament selection");
        Solution<GT, PT> best = population.get(this.r.nextInt(population.size()));
        for (int i = 0; i < this.getTournamentSize() - 1; ++i) {
            Solution<GT, PT> solution = population.get(this.r.nextInt(population.size()));
            if (!(best.getQuality() > solution.getQuality())) continue;
            best = solution;
        }
        logger.trace((Object)"Finished tournament selection");
        return best;
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("tournamentSize", new Descriptor((Object)this.tournamentSize));
        return options;
    }

    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("tournamentSize")) {
                this.setTournamentSize((Integer)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

