/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.ga.crossover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.algorithm.ga.crossover.AbstractCrossover;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.options.Descriptor;

public class UniformCrossover<ST, PT>
extends AbstractCrossover<ST, PT>
implements Configurable {
    private final Random random = new Random();
    protected double crossoverRate = 0.5;

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    @Override
    public Solution<ST, PT> breedTwo(Solution<ST, PT> a, Solution<ST, PT> b) {
        if (a == null || a.getSolutionGenes() == null || a.getSolutionGenes().size() == 0) {
            if (b == null || b.getSolutionGenes() == null || b.getSolutionGenes().size() == 0) {
                return null;
            }
            return b;
        }
        if (b == null || b.getSolutionGenes() == null || b.getSolutionGenes().size() == 0) {
            return a;
        }
        ArrayList<SolutionGene> genes = new ArrayList<SolutionGene>();
        int length = Math.min(a.getSolutionGenes().size(), b.getSolutionGenes().size());
        for (int i = 0; i < length; ++i) {
            if (this.random.nextDouble() < this.getCrossoverRate()) {
                genes.add((SolutionGene)a.getSolutionGenes().get(i));
                continue;
            }
            genes.add((SolutionGene)b.getSolutionGenes().get(i));
        }
        Solution crossoverSolution = new Solution();
        crossoverSolution.setSolutionGenes(genes);
        return crossoverSolution;
    }

    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("crossoverRate", new Descriptor((Object)this.crossoverRate));
        return options;
    }

    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("crossoverRate")) {
                this.setCrossoverRate((Double)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

