/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.ga.crossover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.ga.crossover.AbstractCrossover;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.options.Descriptor;

public class OnePointCrossover<ST, PT>
extends AbstractCrossover<ST, PT>
implements Configurable {
    public static int runs = 0;
    private double crossoverPoint = 0.5;

    @Override
    public Solution<ST, PT> breedTwo(Solution<ST, PT> a, Solution<ST, PT> b) {
        if (a == null || a.getSolutionGenes() == null || a.getSolutionGenes().size() == 0) {
            if (b == null || b.getSolutionGenes() == null || b.getSolutionGenes().size() == 0) {
                return null;
            }
            return b;
        }
        if (b == null || b.getSolutionGenes() == null || b.getSolutionGenes().size() == 0) {
            return a;
        }
        ++runs;
        ArrayList genes = new ArrayList();
        int point = (int)Math.round((double)a.getSolutionGenes().size() * this.getCrossoverPoint());
        genes.addAll(a.getSolutionGenes().subList(0, point));
        genes.addAll(b.getSolutionGenes().subList(point, b.getSolutionGenes().size()));
        Solution crossoverSolution = new Solution();
        crossoverSolution.setSolutionGenes(genes);
        return crossoverSolution;
    }

    public double getCrossoverPoint() {
        return this.crossoverPoint;
    }

    public void setCrossoverPoint(double crossoverPoint) {
        this.crossoverPoint = crossoverPoint;
    }

    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("crossoverPoint", new Descriptor((Object)this.crossoverPoint));
        return options;
    }

    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("crossoverPoint")) {
                this.setCrossoverPoint((Double)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

