/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.ga;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import science.aist.machinelearning.algorithm.ga.Crossover;
import science.aist.machinelearning.algorithm.ga.Selector;
import science.aist.machinelearning.algorithm.mutation.Mutator;
import science.aist.machinelearning.core.AbstractAlgorithm;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.options.Descriptor;

public class GeneticAlgorithm<GT, PT>
extends AbstractAlgorithm<GT, PT> {
    private static final Logger logger = Logger.getLogger(GeneticAlgorithm.class);
    private final Random random = new Random();
    protected Solution<GT, PT> bestSolution;
    private Crossover<GT, PT> crossover;
    private Mutator<GT, PT> mutator;
    private double mutationProbability;
    private Selector<GT, PT> selector;
    private int populationSize;
    private int elites;
    private int maximumGenerations;
    private int currentGeneration;
    private List<Solution<GT, PT>> population = new ArrayList<Solution<GT, PT>>();
    private boolean logInitialized = false;
    private boolean logFinalized = false;

    public Solution<GT, PT> solve(Problem<PT> problem) {
        if (problem == null || problem.getProblemGenes() == null || problem.getProblemGenes().isEmpty()) {
            return null;
        }
        this.initializeLog(problem);
        this.bestSolution = this.solutionCreator.createSolution(problem);
        this.evaluator.evaluateQuality(this.bestSolution);
        return this.solve(problem, this.bestSolution);
    }

    public Solution<GT, PT> solve(Problem<PT> problem, Solution<GT, PT> givenSolution) {
        if (problem == null || problem.getProblemGenes() == null || problem.getProblemGenes().isEmpty() || givenSolution == null) {
            return null;
        }
        this.initializeLog(problem);
        if (givenSolution.getCachets().size() == 0) {
            this.getEvaluator().evaluateQuality(givenSolution);
        }
        this.bestSolution = givenSolution;
        if (this.currentGeneration == 0) {
            this.fillPopulation(problem);
            this.analyticsStep(this.bestSolution, this.population);
            ++this.currentGeneration;
        }
        while (this.currentGeneration < this.maximumGenerations) {
            this.bestSolution = this.nextGeneration(problem);
        }
        this.finalizeLog(problem);
        return this.bestSolution;
    }

    protected void reset() {
        this.bestSolution = null;
        this.population.clear();
        this.currentGeneration = 0;
        this.logInitialized = false;
        this.logFinalized = false;
    }

    protected void initializeLog(Problem<PT> problem) {
        if (this.analytics != null && !this.logInitialized) {
            this.logInitialized = true;
            this.analytics.startAnalytics();
            this.analytics.logParam("problemSize", problem.getProblemSize());
            this.analytics.logParam("crossover", this.crossover != null ? this.crossover.getClass().getName() : "no crossover");
            this.analytics.logParam("mutator", this.mutator.getClass().getName());
            this.analytics.logParam("selector", this.selector.getClass().getName());
            this.analytics.logParam("creator", this.solutionCreator.getClass().getName());
            this.analytics.logParam("mutationProbability", String.valueOf(this.mutationProbability));
            this.analytics.logParam("populationSize", String.valueOf(this.populationSize));
            this.analytics.logParam("elites", String.valueOf(this.elites));
            this.analytics.logParam("maximumGenerations", String.valueOf(this.maximumGenerations));
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("best quality");
            headers.add("worst quality");
            headers.add("average quality");
            this.analytics.logAlgorithmStepHeaders(headers);
            this.analytics.logProblem(problem);
        }
    }

    protected void finalizeLog(Problem<PT> problem) {
        if (this.logFinalized) {
            return;
        }
        if (this.analytics != null) {
            this.logSolution(this.bestSolution);
            this.analytics.finishAnalytics();
        }
        this.logFinalized = true;
    }

    private void fillPopulation(Problem<PT> problem) {
        for (int i = this.population.size(); i < this.populationSize; ++i) {
            Solution s = this.solutionCreator.createSolution(problem);
            this.bestSolution = this.bestQuality(s, this.bestSolution);
            this.population.add(s);
        }
    }

    public Solution<GT, PT> nextGeneration(Problem<PT> problem) {
        if (this.currentGeneration >= this.maximumGenerations) {
            this.finalizeLog(problem);
            return null;
        }
        if (this.currentGeneration == 0) {
            this.initializeLog(problem);
        }
        ++this.currentGeneration;
        if (this.bestSolution.getCachets().isEmpty()) {
            this.getEvaluator().evaluateQuality(this.bestSolution);
        }
        this.fillPopulation(problem);
        this.population.forEach(x -> {
            if (x.getCachets().size() == 0) {
                this.bestSolution = this.bestQuality((Solution<GT, PT>)x, this.bestSolution);
            }
        });
        ArrayList<Solution<GT, PT>> childPopulation = new ArrayList<Solution<GT, PT>>();
        if (this.elites > 0) {
            this.population.sort(Comparator.comparingDouble(Solution::getQuality));
            int size = Math.min(this.elites, this.populationSize);
            childPopulation.addAll(this.population.subList(0, size));
        }
        while (childPopulation.size() < this.populationSize) {
            Solution<GT, PT> s;
            if (this.crossover != null && this.mutationProbability < this.random.nextDouble()) {
                s = this.crossover.breed(this.population, this.selector);
            } else {
                s = this.selector.select(this.population);
                s = this.mutator.mutate(s);
            }
            this.bestSolution = this.bestQuality(s, this.bestSolution);
            childPopulation.add(s);
        }
        this.population = childPopulation;
        this.analyticsStep(this.bestSolution, this.population);
        return this.bestSolution;
    }

    private void analyticsStep(Solution<GT, PT> givenSolution, List<Solution<GT, PT>> population) {
        if (this.analytics != null) {
            Solution<GT, PT> worstSolution = population.stream().max(Comparator.comparingDouble(Solution::getQuality)).orElse(givenSolution);
            double averageQuality = population.stream().mapToDouble(Solution::getQuality).average().orElse(0.0);
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(givenSolution.getQuality()));
            values.add(String.valueOf(worstSolution.getQuality()));
            values.add(String.valueOf(averageQuality));
            this.analytics.logAlgorithmStep(values);
        }
    }

    public Solution<GT, PT> bestQuality(Solution<GT, PT> solution, Solution<GT, PT> givenSolution) {
        this.evaluator.evaluateQuality(solution);
        if (solution.getQuality() < givenSolution.getQuality()) {
            this.bestSolution = solution;
        }
        return this.bestSolution;
    }

    public void logSolution(Solution<GT, PT> solution) {
        this.getAnalytics().logSolution(solution);
    }

    public void setGenMutator(Mutator<GT, PT> mutator) {
        this.mutator = mutator;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    @Required
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public int getMaximumGenerations() {
        return this.maximumGenerations;
    }

    @Required
    public void setMaximumGenerations(int maximumGenerations) {
        this.maximumGenerations = maximumGenerations;
    }

    public Crossover<GT, PT> getCrossover() {
        return this.crossover;
    }

    public void setCrossover(Crossover<GT, PT> crossover) {
        this.crossover = crossover;
    }

    public Mutator<GT, PT> getMutator() {
        return this.mutator;
    }

    public Selector<GT, PT> getSelector() {
        return this.selector;
    }

    @Required
    public void setSelector(Selector<GT, PT> selector) {
        this.selector = selector;
    }

    public int getElites() {
        return this.elites;
    }

    public void setElites(int elites) {
        this.elites = elites;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    public List<Solution<GT, PT>> getPopulation() {
        return new ArrayList<Solution<GT, PT>>(this.population);
    }

    public boolean addIndividual(Solution<GT, PT> individual) {
        if (this.population.size() < this.populationSize) {
            this.population.add(individual);
            return true;
        }
        return false;
    }

    public boolean removeIndividual(Solution<GT, PT> individual) {
        if (this.population.contains(individual)) {
            this.population.remove(individual);
            return true;
        }
        return false;
    }

    protected Map<String, Descriptor> getSpecificOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("crossover", new Descriptor(this.crossover));
        options.put("mutator", new Descriptor(this.mutator));
        options.put("mutationProbability", new Descriptor((Object)this.mutationProbability));
        options.put("selector", new Descriptor(this.selector));
        options.put("populationSize", new Descriptor((Object)this.populationSize));
        options.put("elites", new Descriptor((Object)this.elites));
        options.put("maximumGenerations", new Descriptor((Object)this.maximumGenerations));
        return options;
    }

    protected boolean setSpecificOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "crossover": {
                    this.setCrossover((Crossover)descriptor.getValue());
                    break;
                }
                case "mutator": {
                    this.setGenMutator((Mutator)descriptor.getValue());
                    break;
                }
                case "mutationProbability": {
                    this.setMutationProbability((Double)descriptor.getValue());
                    break;
                }
                case "selector": {
                    this.setSelector((Selector)descriptor.getValue());
                    break;
                }
                case "populationSize": {
                    this.setPopulationSize((Integer)descriptor.getValue());
                    break;
                }
                case "elites": {
                    this.setElites((Integer)descriptor.getValue());
                    break;
                }
                case "maximumGenerations": {
                    this.setMaximumGenerations((Integer)descriptor.getValue());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

