/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.cmaes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import science.aist.machinelearning.algorithm.cmaes.FloatValueProblem;
import science.aist.machinelearning.algorithm.cmaes.operator.RealValuedSolutionBuilder;
import science.aist.machinelearning.core.AbstractAlgorithm;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.options.Descriptor;
import science.aist.machinelearning.core.util.RandomUtil;

public class CovarianceMatrixAdaptionEvolutionStrategy<ST, PT extends FloatValueProblem>
extends AbstractAlgorithm<ST, PT> {
    private final List<Solution<ST, PT>> population = new ArrayList<Solution<ST, PT>>();
    protected Solution<ST, PT> bestSolution;
    private int maximumGenerations;
    private int currentGeneration;
    private RealValuedSolutionBuilder<ST, PT> solutionBuilder;
    private boolean logInitialized = false;
    private boolean logFinalized = false;
    private double[] initialSearchPosition = null;
    private double standardDeviation = 0.5;
    private int diagonalIterations = -1;
    private int populationSize = 50;
    private double[] evolutionPath;
    private double[] scalingFactor;
    private double[] evolutionPathNextGeneration;
    private double[][] covarianceCoordinateSystem;
    private double[][] covarianceMatrix;
    private double[] distributionCentroid;
    private double chiSquaredDistributionOfVariables = -1.0;
    private int crossoverParentCount = -1;
    private double[] crossoverWeights;
    private double varianceEffectiveness = -1.0;
    private double cumulationStepSize = -1.0;
    private double cumulation = -1.0;
    private double learningRate = -1.0;
    private double learningRateDiagonal = -1.0;
    private double stepSizeDampening = -1.0;
    private double lastEigenupdate;
    private boolean checkConsistency = true;

    public static void matrixToTridiagonalReduction(int variableCount, double[][] covarianceCoordinateSystem, double[] scalingFactor, double[] diagonal) {
        int i;
        System.arraycopy(covarianceCoordinateSystem[variableCount - 1], 0, scalingFactor, 0, variableCount);
        for (i = variableCount - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double newScalingFactor = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(scalingFactor[k]);
            }
            if (scale == 0.0) {
                diagonal[i] = scalingFactor[i - 1];
                for (int j = 0; j < i; ++j) {
                    scalingFactor[j] = covarianceCoordinateSystem[i - 1][j];
                    covarianceCoordinateSystem[i][j] = 0.0;
                    covarianceCoordinateSystem[j][i] = 0.0;
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    scalingFactor[n] = scalingFactor[n] / scale;
                    newScalingFactor += scalingFactor[k] * scalingFactor[k];
                }
                double ScalingFactorI = scalingFactor[i - 1];
                double newDiagonalValue = Math.sqrt(newScalingFactor);
                if (ScalingFactorI > 0.0) {
                    newDiagonalValue = -newDiagonalValue;
                }
                diagonal[i] = scale * newDiagonalValue;
                newScalingFactor -= ScalingFactorI * newDiagonalValue;
                scalingFactor[i - 1] = ScalingFactorI - newDiagonalValue;
                for (j2 = 0; j2 < i; ++j2) {
                    diagonal[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    covarianceCoordinateSystem[j2][i] = ScalingFactorI = scalingFactor[j2];
                    newDiagonalValue = diagonal[j2] + covarianceCoordinateSystem[j2][j2] * ScalingFactorI;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        newDiagonalValue += covarianceCoordinateSystem[k2][j2] * scalingFactor[k2];
                        int n = k2;
                        diagonal[n] = diagonal[n] + covarianceCoordinateSystem[k2][j2] * ScalingFactorI;
                    }
                    diagonal[j2] = newDiagonalValue;
                }
                ScalingFactorI = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n = j2;
                    diagonal[n] = diagonal[n] / newScalingFactor;
                    ScalingFactorI += diagonal[j2] * scalingFactor[j2];
                }
                double diagonalAdaption = ScalingFactorI / (newScalingFactor + newScalingFactor);
                for (j = 0; j < i; ++j) {
                    int n = j;
                    diagonal[n] = diagonal[n] - diagonalAdaption * scalingFactor[j];
                }
                for (j = 0; j < i; ++j) {
                    ScalingFactorI = scalingFactor[j];
                    newDiagonalValue = diagonal[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        double[] dArray = covarianceCoordinateSystem[k3];
                        int n = j;
                        dArray[n] = dArray[n] - (ScalingFactorI * diagonal[k3] + newDiagonalValue * scalingFactor[k3]);
                    }
                    scalingFactor[j] = covarianceCoordinateSystem[i - 1][j];
                    covarianceCoordinateSystem[i][j] = 0.0;
                }
            }
            scalingFactor[i] = newScalingFactor;
        }
        for (i = 0; i < variableCount - 1; ++i) {
            int k;
            covarianceCoordinateSystem[variableCount - 1][i] = covarianceCoordinateSystem[i][i];
            covarianceCoordinateSystem[i][i] = 1.0;
            double h = scalingFactor[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    scalingFactor[k] = covarianceCoordinateSystem[k][i + 1] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += covarianceCoordinateSystem[k4][i + 1] * covarianceCoordinateSystem[k4][j];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = covarianceCoordinateSystem[k4];
                        int n = j;
                        dArray[n] = dArray[n] - g * scalingFactor[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                covarianceCoordinateSystem[k][i + 1] = 0.0;
            }
        }
        for (int j = 0; j < variableCount; ++j) {
            scalingFactor[j] = covarianceCoordinateSystem[variableCount - 1][j];
            covarianceCoordinateSystem[variableCount - 1][j] = 0.0;
        }
        covarianceCoordinateSystem[variableCount - 1][variableCount - 1] = 1.0;
        diagonal[0] = 0.0;
    }

    public static void computeEigenvaluesOfTridiagonal(int variableCount, double[] scalingFactor, double[] diagonal, double[][] covarianceCoordinateSystem) {
        System.arraycopy(diagonal, 1, diagonal, 0, variableCount - 1);
        diagonal[variableCount - 1] = 0.0;
        double scalingFactorAdaption = 0.0;
        double subiagonalElement = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < variableCount; ++l) {
            int m;
            subiagonalElement = Math.max(subiagonalElement, Math.abs(scalingFactor[l]) + Math.abs(diagonal[l]));
            for (m = l; m < variableCount && !(Math.abs(diagonal[m]) <= eps * subiagonalElement); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double eigenvalue = scalingFactor[l];
                    double adaptionValue = (scalingFactor[l + 1] - eigenvalue) / (2.0 * diagonal[l]);
                    double adaptionValueHypothenuse = CovarianceMatrixAdaptionEvolutionStrategy.hypotenuse(adaptionValue, 1.0);
                    if (adaptionValue < 0.0) {
                        adaptionValueHypothenuse = -adaptionValueHypothenuse;
                    }
                    scalingFactor[l] = diagonal[l] / (adaptionValue + adaptionValueHypothenuse);
                    scalingFactor[l + 1] = diagonal[l] * (adaptionValue + adaptionValueHypothenuse);
                    double nextScalingFactor = scalingFactor[l + 1];
                    double eigenvalueAdaption = eigenvalue - scalingFactor[l];
                    int i = l + 2;
                    while (i < variableCount) {
                        int n = i++;
                        scalingFactor[n] = scalingFactor[n] - eigenvalueAdaption;
                    }
                    scalingFactorAdaption += eigenvalueAdaption;
                    adaptionValue = scalingFactor[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double nextDiagonal = diagonal[l + 1];
                    double diagonalAdaption = 0.0;
                    double nextDiagonalAdaption = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        nextDiagonalAdaption = diagonalAdaption;
                        eigenvalue = c * diagonal[i2];
                        eigenvalueAdaption = c * adaptionValue;
                        adaptionValueHypothenuse = CovarianceMatrixAdaptionEvolutionStrategy.hypotenuse(adaptionValue, diagonal[i2]);
                        diagonal[i2 + 1] = diagonalAdaption * adaptionValueHypothenuse;
                        diagonalAdaption = diagonal[i2] / adaptionValueHypothenuse;
                        c = adaptionValue / adaptionValueHypothenuse;
                        adaptionValue = c * scalingFactor[i2] - diagonalAdaption * eigenvalue;
                        scalingFactor[i2 + 1] = eigenvalueAdaption + diagonalAdaption * (c * eigenvalue + diagonalAdaption * scalingFactor[i2]);
                        for (int k = 0; k < variableCount; ++k) {
                            eigenvalueAdaption = covarianceCoordinateSystem[k][i2 + 1];
                            covarianceCoordinateSystem[k][i2 + 1] = diagonalAdaption * covarianceCoordinateSystem[k][i2] + c * eigenvalueAdaption;
                            covarianceCoordinateSystem[k][i2] = c * covarianceCoordinateSystem[k][i2] - diagonalAdaption * eigenvalueAdaption;
                        }
                    }
                    adaptionValue = -diagonalAdaption * nextDiagonalAdaption * c3 * nextDiagonal * diagonal[l] / nextScalingFactor;
                    diagonal[l] = diagonalAdaption * adaptionValue;
                    scalingFactor[l] = c * adaptionValue;
                } while (Math.abs(diagonal[l]) > eps * subiagonalElement);
            }
            scalingFactor[l] = scalingFactor[l] + scalingFactorAdaption;
            diagonal[l] = 0.0;
        }
        for (int i = 0; i < variableCount - 1; ++i) {
            int j;
            int k = i;
            double newCovarianceCoordinate = scalingFactor[i];
            for (j = i + 1; j < variableCount; ++j) {
                if (!(scalingFactor[j] < newCovarianceCoordinate)) continue;
                k = j;
                newCovarianceCoordinate = scalingFactor[j];
            }
            if (k == i) continue;
            scalingFactor[k] = scalingFactor[i];
            scalingFactor[i] = newCovarianceCoordinate;
            for (j = 0; j < variableCount; ++j) {
                newCovarianceCoordinate = covarianceCoordinateSystem[j][i];
                covarianceCoordinateSystem[j][i] = covarianceCoordinateSystem[j][k];
                covarianceCoordinateSystem[j][k] = newCovarianceCoordinate;
            }
        }
    }

    private static int checkEigenSystem(int variableCount, double[][] covarianceMatrix, double[] scalingFactor, double[][] covarianceCoordinateSystem) {
        int errors = 0;
        for (int i = 0; i < variableCount; ++i) {
            for (int j = 0; j < variableCount; ++j) {
                double cc = 0.0;
                double dd = 0.0;
                for (int k = 0; k < variableCount; ++k) {
                    cc += scalingFactor[k] * covarianceCoordinateSystem[i][k] * covarianceCoordinateSystem[j][k];
                    dd += covarianceCoordinateSystem[i][k] * covarianceCoordinateSystem[j][k];
                }
                if (Math.abs(cc - covarianceMatrix[Math.max(i, j)][Math.min(i, j)]) / Math.sqrt(covarianceMatrix[i][i] * covarianceMatrix[j][j]) > 1.0E-10 && Math.abs(cc - covarianceMatrix[Math.max(i, j)][Math.min(i, j)]) > 1.0E-9) {
                    System.err.println("imprecise result detected " + i + " " + j + " " + cc + " " + covarianceMatrix[Math.max(i, j)][Math.min(i, j)] + " " + (cc - covarianceMatrix[Math.max(i, j)][Math.min(i, j)]));
                    ++errors;
                }
                boolean bl = i == j;
                if (!(Math.abs(dd - (double)bl) > 1.0E-10)) continue;
                System.err.println("imprecise result detected (covarianceCoordinateSystem not orthog.) " + i + " " + j + " " + dd);
                ++errors;
            }
        }
        return errors;
    }

    private static double hypotenuse(double a, double b) {
        double hypot = 0.0;
        if (Math.abs(a) > Math.abs(b)) {
            hypot = b / a;
            hypot = Math.abs(a) * Math.sqrt(1.0 + hypot * hypot);
        } else if (b != 0.0) {
            hypot = a / b;
            hypot = Math.abs(b) * Math.sqrt(1.0 + hypot * hypot);
        }
        return hypot;
    }

    protected Map<String, Descriptor> getSpecificOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("maximumGenerations", new Descriptor((Object)this.maximumGenerations));
        options.put("checkConsistency", new Descriptor((Object)this.checkConsistency));
        options.put("solutionBuilder", new Descriptor(this.solutionBuilder));
        options.put("initialSearchPosition", new Descriptor((Object)this.initialSearchPosition));
        options.put("diagonalIterations", new Descriptor((Object)this.diagonalIterations));
        options.put("populationSize", new Descriptor((Object)this.populationSize));
        options.put("cumulationStepSize", new Descriptor((Object)this.cumulationStepSize));
        options.put("cumulation", new Descriptor((Object)this.cumulation));
        options.put("learningRate", new Descriptor((Object)this.learningRate));
        options.put("learningRateDiagonal", new Descriptor((Object)this.learningRateDiagonal));
        options.put("stepSizeDampening", new Descriptor((Object)this.stepSizeDampening));
        options.put("standardDeviation", new Descriptor((Object)this.standardDeviation));
        return options;
    }

    protected boolean setSpecificOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "maximumGenerations": {
                    this.setMaximumGenerations((Integer)descriptor.getValue());
                    break;
                }
                case "checkConsistency": {
                    this.setCheckConsistency((Boolean)descriptor.getValue());
                    break;
                }
                case "solutionBuilder": {
                    this.setSolutionBuilder((RealValuedSolutionBuilder)descriptor.getValue());
                    break;
                }
                case "initialSearchPosition": {
                    this.setInitialSearchPosition((double[])descriptor.getValue());
                    break;
                }
                case "diagonalIterations": {
                    this.setDiagonalIterations((Integer)descriptor.getValue());
                    break;
                }
                case "populationSize": {
                    this.setPopulationSize((Integer)descriptor.getValue());
                    break;
                }
                case "cumulationStepSize": {
                    this.setCumulationStepSize((Double)descriptor.getValue());
                    break;
                }
                case "cumulation": {
                    this.setCumulation((Double)descriptor.getValue());
                    break;
                }
                case "learningRate": {
                    this.setLearningRate((Double)descriptor.getValue());
                    break;
                }
                case "learningRateDiagonal": {
                    this.setLearningRateDiagonal((Double)descriptor.getValue());
                    break;
                }
                case "stepSizeDampening": {
                    this.setStepSizeDampening((Double)descriptor.getValue());
                    break;
                }
                case "standardDeviation": {
                    this.setStandardDeviation((Double)descriptor.getValue());
                    break;
                }
                default: {
                    System.out.println("WARNING: Option " + name + " unknown");
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("WARNING: Option " + name + " could not be set");
            return false;
        }
        return true;
    }

    protected void initializeLog(Problem<PT> problem) {
        if (this.analytics != null && !this.logInitialized) {
            this.logInitialized = true;
            this.analytics.startAnalytics();
            this.analytics.logParam("problemSize", problem.getProblemSize());
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("best quality");
            headers.add("worst quality");
            headers.add("average quality");
            this.analytics.logAlgorithmStepHeaders(headers);
            this.analytics.logProblem(problem);
        }
    }

    protected void finalizeLog(Problem<PT> problem) {
        if (this.logFinalized) {
            return;
        }
        if (this.analytics != null) {
            this.getAnalytics().logSolution(this.bestSolution);
            this.analytics.finishAnalytics();
        }
        this.logFinalized = true;
    }

    private void analyticsStep(Solution<ST, PT> givenSolution, List<Solution<ST, PT>> population) {
        if (this.analytics != null) {
            Solution<ST, PT> worstSolution = population.stream().max(Comparator.comparingDouble(Solution::getQuality)).orElse(givenSolution);
            double averageQuality = population.stream().mapToDouble(Solution::getQuality).average().orElse(0.0);
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(givenSolution.getQuality()));
            values.add(String.valueOf(worstSolution.getQuality()));
            values.add(String.valueOf(averageQuality));
            this.analytics.logAlgorithmStep(values);
        }
    }

    public Solution<ST, PT> solve(Problem<PT> problem) {
        if (problem == null || problem.getProblemGenes() == null || problem.getProblemGenes().isEmpty()) {
            return null;
        }
        this.initializeLog(problem);
        this.bestSolution = this.solutionBuilder.transformToSolution(this.initialSearchPosition != null ? this.initialSearchPosition : new double[((FloatValueProblem)((ProblemGene)problem.getProblemGenes().get(0)).getGene()).getVariableCount()], problem);
        this.evaluator.evaluateQuality(this.bestSolution);
        return this.solve(problem, this.bestSolution);
    }

    public Solution<ST, PT> solve(Problem<PT> problem, Solution<ST, PT> bestSolution) {
        if (problem == null || problem.getProblemGenes() == null || problem.getProblemGenes().isEmpty() || bestSolution == null) {
            return null;
        }
        this.initializeLog(problem);
        if (bestSolution.getCachets().isEmpty()) {
            this.getEvaluator().evaluateQuality(bestSolution);
        }
        this.bestSolution = bestSolution;
        if (this.currentGeneration == 0) {
            this.initialize(problem);
        }
        while (this.currentGeneration < this.maximumGenerations) {
            bestSolution = this.nextGeneration(problem);
        }
        this.finalizeLog(problem);
        return bestSolution;
    }

    public Solution<ST, PT> bestQuality(Solution<ST, PT> solution, Solution<ST, PT> givenSolution) {
        this.evaluator.evaluateQuality(solution);
        if (solution.getQuality() < givenSolution.getQuality()) {
            this.bestSolution = solution;
        }
        return this.bestSolution;
    }

    public void setMaximumGenerations(int maximumGenerations) {
        this.maximumGenerations = maximumGenerations;
    }

    public Solution<ST, PT> nextGeneration(Problem<PT> problem) {
        int variableCount = ((FloatValueProblem)((ProblemGene)problem.getProblemGenes().get(0)).getGene()).getVariableCount();
        if ((double)this.currentGeneration - this.lastEigenupdate > 1.0 / this.learningRate / (double)variableCount / 5.0) {
            this.eigendecomposition(variableCount);
        }
        if (this.checkConsistency) {
            this.performConsistencyUpdate(variableCount);
        }
        this.population.clear();
        for (int i = 0; i < this.populationSize; ++i) {
            double[] solutionVariables = new double[variableCount];
            if (this.diagonalIterations > this.currentGeneration) {
                for (int j = 0; j < variableCount; ++j) {
                    solutionVariables[j] = this.distributionCentroid[j] + this.standardDeviation * this.scalingFactor[j] * RandomUtil.random.nextGaussian();
                }
            } else {
                int j;
                double[] randomVariableMutation = new double[variableCount];
                for (j = 0; j < variableCount; ++j) {
                    randomVariableMutation[j] = this.scalingFactor[j] * RandomUtil.random.nextGaussian();
                }
                for (j = 0; j < variableCount; ++j) {
                    double sum = 0.0;
                    for (int k = 0; k < variableCount; ++k) {
                        sum += this.covarianceCoordinateSystem[j][k] * randomVariableMutation[k];
                    }
                    solutionVariables[j] = this.distributionCentroid[j] + this.standardDeviation * sum;
                }
            }
            Solution<ST, PT> newSolution = this.solutionBuilder.transformToSolution(solutionVariables, problem);
            this.bestSolution = this.bestQuality(newSolution, this.bestSolution);
            this.population.add(newSolution);
        }
        ++this.currentGeneration;
        this.updateDistribution(variableCount);
        this.analyticsStep(this.bestSolution, this.population);
        return this.bestSolution;
    }

    private void updateDistribution(int variableCount) {
        int i;
        int j;
        int i2;
        double[] oldDistributionCentroid = Arrays.copyOf(this.distributionCentroid, this.distributionCentroid.length);
        double[] evaluationPathAdaption = new double[variableCount];
        this.population.sort(Comparator.comparingDouble(Solution::getQuality));
        for (i2 = 0; i2 < variableCount; ++i2) {
            this.distributionCentroid[i2] = 0.0;
            Iterator<Solution<ST, PT>> iterator = this.population.iterator();
            for (int j2 = 0; j2 < this.crossoverParentCount; ++j2) {
                Solution<ST, PT> s = iterator.next();
                int n = i2;
                this.distributionCentroid[n] = this.distributionCentroid[n] + this.crossoverWeights[j2] * this.solutionBuilder.getVaribleFromOriginalVector(s, i2);
            }
            evaluationPathAdaption[i2] = Math.sqrt(this.varianceEffectiveness) * (this.distributionCentroid[i2] - oldDistributionCentroid[i2]) / this.standardDeviation;
        }
        if (this.diagonalIterations > this.currentGeneration) {
            for (i2 = 0; i2 < variableCount; ++i2) {
                this.evolutionPathNextGeneration[i2] = (1.0 - this.cumulationStepSize) * this.evolutionPathNextGeneration[i2] + Math.sqrt(this.cumulationStepSize * (2.0 - this.cumulationStepSize)) * evaluationPathAdaption[i2] / this.scalingFactor[i2];
            }
        } else {
            int i3;
            double[] coordinateSystemInfluence = new double[variableCount];
            for (i3 = 0; i3 < variableCount; ++i3) {
                double sum = 0.0;
                for (j = 0; j < variableCount; ++j) {
                    sum += this.covarianceCoordinateSystem[j][i3] * evaluationPathAdaption[j];
                }
                coordinateSystemInfluence[i3] = sum / this.scalingFactor[i3];
            }
            for (i3 = 0; i3 < variableCount; ++i3) {
                double sum = 0.0;
                for (j = 0; j < variableCount; ++j) {
                    sum += this.covarianceCoordinateSystem[i3][j] * coordinateSystemInfluence[j];
                }
                this.evolutionPathNextGeneration[i3] = (1.0 - this.cumulationStepSize) * this.evolutionPathNextGeneration[i3] + Math.sqrt(this.cumulationStepSize * (2.0 - this.cumulationStepSize)) * sum;
            }
        }
        double evolutionPathCubeSum = 0.0;
        for (int i4 = 0; i4 < variableCount; ++i4) {
            evolutionPathCubeSum += this.evolutionPathNextGeneration[i4] * this.evolutionPathNextGeneration[i4];
        }
        int cumulationIsAdded = 0;
        if (Math.sqrt(evolutionPathCubeSum) / Math.sqrt(1.0 - Math.pow(1.0 - this.cumulationStepSize, 2.0 * (double)this.currentGeneration)) / this.chiSquaredDistributionOfVariables < 1.4 + 2.0 / (double)(variableCount + 1)) {
            cumulationIsAdded = 1;
        }
        for (i = 0; i < variableCount; ++i) {
            this.evolutionPath[i] = (1.0 - this.cumulation) * this.evolutionPath[i] + (double)cumulationIsAdded * Math.sqrt(this.cumulation * (2.0 - this.cumulation)) * evaluationPathAdaption[i];
        }
        for (i = 0; i < variableCount; ++i) {
            int n = j = this.diagonalIterations >= this.currentGeneration ? i : 0;
            while (j <= i) {
                this.covarianceMatrix[i][j] = (1.0 - (this.diagonalIterations >= this.currentGeneration ? this.learningRateDiagonal : this.learningRate)) * this.covarianceMatrix[i][j] + this.learningRate * (1.0 / this.varianceEffectiveness) * (this.evolutionPath[i] * this.evolutionPath[j] + (double)(1 - cumulationIsAdded) * this.cumulation * (2.0 - this.cumulation) * this.covarianceMatrix[i][j]);
                for (int k = 0; k < this.crossoverParentCount; ++k) {
                    Solution<ST, PT> s = this.population.get(k);
                    double[] dArray = this.covarianceMatrix[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.learningRate * (1.0 - 1.0 / this.varianceEffectiveness) * this.crossoverWeights[k] * (this.solutionBuilder.getVaribleFromOriginalVector(s, i) - oldDistributionCentroid[i]) * (this.solutionBuilder.getVaribleFromOriginalVector(s, j) - oldDistributionCentroid[j]) / this.standardDeviation / this.standardDeviation;
                }
                ++j;
            }
        }
        this.standardDeviation *= Math.exp((Math.sqrt(evolutionPathCubeSum) / this.chiSquaredDistributionOfVariables - 1.0) * this.cumulationStepSize / this.stepSizeDampening);
    }

    private void eigendecomposition(int variableCount) {
        this.lastEigenupdate = this.currentGeneration;
        if (this.diagonalIterations >= this.currentGeneration) {
            for (int i = 0; i < variableCount; ++i) {
                this.scalingFactor[i] = Math.sqrt(this.covarianceMatrix[i][i]);
            }
        } else {
            for (int i = 0; i < variableCount; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double d = this.covarianceMatrix[i][j];
                    this.covarianceCoordinateSystem[j][i] = d;
                    this.covarianceCoordinateSystem[i][j] = d;
                }
            }
            double[] diagonal = new double[variableCount];
            CovarianceMatrixAdaptionEvolutionStrategy.matrixToTridiagonalReduction(variableCount, this.covarianceCoordinateSystem, this.scalingFactor, diagonal);
            CovarianceMatrixAdaptionEvolutionStrategy.computeEigenvaluesOfTridiagonal(variableCount, this.scalingFactor, diagonal, this.covarianceCoordinateSystem);
            if (this.checkConsistency) {
                CovarianceMatrixAdaptionEvolutionStrategy.checkEigenSystem(variableCount, this.covarianceMatrix, this.scalingFactor, this.covarianceCoordinateSystem);
            }
            for (int i = 0; i < variableCount; ++i) {
                if (this.scalingFactor[i] < 0.0) {
                    System.err.println("an eigenvalue has become negative");
                    this.scalingFactor[i] = 0.0;
                }
                this.scalingFactor[i] = Math.sqrt(this.scalingFactor[i]);
            }
        }
    }

    private void performConsistencyUpdate(int variableCount) {
        if (!this.population.isEmpty()) {
            this.population.sort(Comparator.comparingDouble(Solution::getQuality));
            if (Double.compare(this.population.get(0).getQuality(), this.population.get(Math.min(this.populationSize - 1, this.populationSize / 2 + 1) - 1).getQuality()) == 0) {
                System.err.println("WARNING: Re-Considering FitnessFunction advised. Fitness landscape is too flat. increasing deviation in the meantime");
                this.standardDeviation *= Math.exp(0.2 + this.cumulationStepSize / this.stepSizeDampening);
            }
        }
        double scalingFactorFix = 1.0;
        boolean scalingFactorisWrong = false;
        double maxScale = Arrays.stream(this.scalingFactor).max().orElse(0.0);
        double minScale = Arrays.stream(this.scalingFactor).min().orElse(0.0);
        if (maxScale < 1.0E-6) {
            scalingFactorFix = 1.0 / maxScale;
            scalingFactorisWrong = true;
        } else if (minScale > 10000.0) {
            scalingFactorFix = 1.0 / minScale;
            scalingFactorisWrong = true;
        }
        if (scalingFactorisWrong) {
            this.standardDeviation /= scalingFactorFix;
            for (int i = 0; i < variableCount; ++i) {
                int n = i;
                this.evolutionPath[n] = this.evolutionPath[n] * scalingFactorFix;
                int n2 = i;
                this.scalingFactor[n2] = this.scalingFactor[n2] * scalingFactorFix;
                int j = 0;
                while (j <= i) {
                    double[] dArray = this.covarianceMatrix[i];
                    int n3 = j++;
                    dArray[n3] = dArray[n3] * (scalingFactorFix * scalingFactorFix);
                }
            }
        }
    }

    public void initialize(Problem<PT> problem) {
        int i;
        int variableCount = ((FloatValueProblem)((ProblemGene)problem.getProblemGenes().get(0)).getGene()).getVariableCount();
        if (variableCount <= 0) {
            throw new IllegalArgumentException("We cannot optimize nothing! variable count must be > 0");
        }
        if (this.initialSearchPosition != null && variableCount != this.initialSearchPosition.length) {
            throw new IllegalArgumentException("The initial search position must have the same dimensions as given in the problem");
        }
        if (this.diagonalIterations < 0) {
            this.diagonalIterations = 150 * variableCount / this.populationSize;
        }
        this.scalingFactor = new double[variableCount];
        this.evolutionPath = new double[variableCount];
        this.evolutionPathNextGeneration = new double[variableCount];
        this.covarianceCoordinateSystem = new double[variableCount][variableCount];
        this.covarianceMatrix = new double[variableCount][variableCount];
        Arrays.fill(this.scalingFactor, 1.0);
        for (i = 0; i < variableCount; ++i) {
            this.covarianceCoordinateSystem[i][i] = 1.0;
            this.covarianceMatrix[i][i] = 1.0;
        }
        this.distributionCentroid = new double[variableCount];
        if (this.initialSearchPosition == null) {
            for (i = 0; i < variableCount; ++i) {
                double offset = this.standardDeviation * this.scalingFactor[i];
                this.distributionCentroid[i] = offset + RandomUtil.random.nextDouble();
            }
        } else {
            for (i = 0; i < variableCount; ++i) {
                this.distributionCentroid[i] = this.initialSearchPosition[i] + this.standardDeviation * this.scalingFactor[i] * RandomUtil.random.nextGaussian();
            }
        }
        this.chiSquaredDistributionOfVariables = Math.sqrt(variableCount) * (1.0 - 1.0 / (4.0 * (double)variableCount) + 1.0 / (21.0 * (double)variableCount * (double)variableCount));
        this.crossoverParentCount = (int)Math.floor((double)this.populationSize / 2.0);
        this.crossoverWeights = new double[this.crossoverParentCount];
        for (i = 0; i < this.crossoverParentCount; ++i) {
            this.crossoverWeights[i] = Math.log(this.crossoverParentCount + 1) - Math.log(i + 1);
        }
        double sum = Arrays.stream(this.crossoverWeights).sum();
        int i2 = 0;
        while (i2 < this.crossoverParentCount) {
            int n = i2++;
            this.crossoverWeights[n] = this.crossoverWeights[n] / sum;
        }
        double sumSq = Arrays.stream(this.crossoverWeights).map(x -> x * x).sum();
        this.varianceEffectiveness = 1.0 / sumSq;
        if (this.cumulationStepSize < 0.0) {
            this.cumulationStepSize = (this.varianceEffectiveness + 2.0) / ((double)variableCount + this.varianceEffectiveness + 3.0);
        }
        if (this.stepSizeDampening < 0.0) {
            this.stepSizeDampening = 1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.varianceEffectiveness - 1.0) / (double)(variableCount + 1)) - 1.0) + this.cumulationStepSize;
        }
        if (this.cumulation < 0.0) {
            this.cumulation = 4.0 / ((double)variableCount + 4.0);
        }
        if (this.learningRate < 0.0) {
            this.learningRate = 2.0 / ((double)variableCount + 1.41) / ((double)variableCount + 1.41) / this.varianceEffectiveness + (1.0 - 1.0 / this.varianceEffectiveness) * Math.min(1.0, (2.0 * this.varianceEffectiveness - 1.0) / (this.varianceEffectiveness + (double)((variableCount + 2) * (variableCount + 2))));
        }
        if (this.learningRateDiagonal < 0.0) {
            this.learningRateDiagonal = Math.min(1.0, this.learningRate * ((double)variableCount + 1.5) / 3.0);
        }
        if (this.populationSize <= 1) {
            throw new IllegalArgumentException("population size must be more than 1 (this is a genetic algorithm!)");
        }
        if (this.crossoverParentCount < 1) {
            throw new IllegalArgumentException("number of parents used in recombination must be smaller or equal to populationSize");
        }
        if (this.cumulationStepSize <= 0.0 || this.cumulationStepSize > 1.0) {
            throw new IllegalArgumentException("cumulationStepSize must be between 0 and 1");
        }
        if (this.stepSizeDampening <= 0.0) {
            throw new IllegalArgumentException("step size damping parameter must be > 0");
        }
        if (this.cumulation <= 0.0 || this.cumulation > 1.0) {
            throw new IllegalArgumentException("cumulation must be between 0 and 1");
        }
        if (this.varianceEffectiveness < 0.0) {
            throw new IllegalArgumentException("varianceEffectiveness must be > 0");
        }
        if (this.learningRate < 0.0) {
            throw new IllegalArgumentException("learning rate must be > 0");
        }
        if (this.learningRateDiagonal < 0.0) {
            throw new IllegalArgumentException("diagonal learning rate must be > 0");
        }
        if (this.standardDeviation <= 0.0) {
            throw new IllegalArgumentException("initial standard deviation, must be > 0");
        }
        if (Arrays.stream(this.scalingFactor).anyMatch(x -> x <= 0.0)) {
            throw new IllegalArgumentException("initial standard deviations must be positive");
        }
    }

    public void setCheckConsistency(boolean checkConsistency) {
        this.checkConsistency = checkConsistency;
    }

    public void setSolutionBuilder(RealValuedSolutionBuilder<ST, PT> solutionBuilder) {
        this.solutionBuilder = solutionBuilder;
    }

    public void setInitialSearchPosition(double[] initialSearchPosition) {
        this.initialSearchPosition = initialSearchPosition;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public void setDiagonalIterations(int diagonalIterations) {
        this.diagonalIterations = diagonalIterations;
    }

    public void setStepSizeDampening(double stepSizeDampening) {
        this.stepSizeDampening = stepSizeDampening;
    }

    public void setLearningRateDiagonal(double learningRateDiagonal) {
        this.learningRateDiagonal = learningRateDiagonal;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setCumulation(double cumulation) {
        this.cumulation = cumulation;
    }

    public void setCumulationStepSize(double cumulationStepSize) {
        this.cumulationStepSize = cumulationStepSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }
}

