/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.clustering.kmeans.distance;

import science.aist.machinelearning.algorithm.clustering.kmeans.VectorDistance;

public class CosineVectorDistance
implements VectorDistance {
    @Override
    public double calculateDistance(double[] vector1, double[] vector2) {
        if (vector1.length != vector2.length) {
            throw new IllegalArgumentException("Only supports vectors of same size");
        }
        return this.vectorProduct(vector1, vector2) / (this.vectorLength(vector1) * this.vectorLength(vector2));
    }

    private double vectorLength(double[] vector) {
        int sumSquaredLength = 0;
        for (double vectorI : vector) {
            sumSquaredLength = (int)((double)sumSquaredLength + vectorI * vectorI);
        }
        return Math.sqrt(sumSquaredLength);
    }

    private double vectorProduct(double[] vector1, double[] vector2) {
        double product = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            product += vector1[i] * vector2[i];
        }
        return product;
    }
}

