/*
 * Copyright (c) 2021 the original author or authors.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package science.aist.machinelearning.algorithm.clustering.kmeans;

import java.util.List;

/**
 * <p>Cluster that is going to be returned from a clustering algorithm</p>
 *
 * @author Andreas Pointner
 * @since 1.0
 */
public interface Cluster<T> {
    /**
     * @return the elements in the cluster
     */
    List<T> getElements();

    /**
     * @return the cluster center
     */
    double[] getClusterCenter();
}
