/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness.runtime;

import java.util.Collection;
import org.apache.log4j.Logger;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPTrim;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPRuntimeCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    static final Logger logger = Logger.getLogger(GPRuntimeCachet.class);
    private int runsPerProblem = 1;
    private long evaluationTime = 1000L;
    private long evaluationTimeStep = 50L;
    private Collection<Problem<PT>> problems;
    private boolean finishedCalculation = false;
    private boolean interrupted = false;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            solution.getCachets().add(new Cachet(1.0E8, "GPEvaluationTimerCachet"));
            return 1.0E8;
        }
        SolutionGene currentGene = (SolutionGene)solution.getSolutionGenes().get(0);
        ResultNode trimedGraph = GPTrim.trimGraph((ResultNode)((ResultNode)currentGene.getGene()));
        double quality = 0.0;
        for (Problem<PT> problem : this.problems) {
            int i;
            this.checkForSolutionCreator((GPGraphNode)trimedGraph, problem);
            double problemQuality = 0.0;
            for (i = 0; i < this.runsPerProblem; ++i) {
                this.finishedCalculation = false;
                this.interrupted = false;
                Thread sleepThread = new Thread(() -> {
                    try {
                        for (long sleptFor = 0L; sleptFor < this.evaluationTime && !this.finishedCalculation; sleptFor += this.evaluationTimeStep) {
                            Thread.sleep(this.evaluationTimeStep);
                        }
                        if (!this.finishedCalculation) {
                            this.interrupted = true;
                            BasicNodeUtil.interruptGraph((GPGraphNode)trimedGraph, (boolean)true);
                            logger.info((Object)"Interrupted execution of a gp-graph.");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });
                long duration = System.currentTimeMillis();
                sleepThread.start();
                try {
                    trimedGraph.execute();
                    this.finishedCalculation = true;
                }
                catch (Error e) {
                    System.gc();
                    this.interrupted = true;
                    logger.info((Object)("Had to stop execution because of: " + e.getClass().getName()));
                }
                problemQuality += (double)(System.currentTimeMillis() - duration);
                try {
                    sleepThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.interrupted) continue;
                problemQuality += (double)this.evaluationTime;
                break;
            }
            quality += problemQuality / (double)(i + 1);
        }
        if ((quality /= (double)this.problems.size()) < 0.0 || quality > 1000000.0) {
            quality = 1000000.0;
        }
        solution.getCachets().add(new Cachet(quality, "GPRuntimeCachet"));
        return quality;
    }

    public String getName() {
        return "GPRuntimeCachet";
    }

    public void setRunsPerProblem(int runsPerProblem) {
        this.runsPerProblem = runsPerProblem;
    }

    public void setEvaluationTime(long evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public void setEvaluationTimeStep(long evaluationTimeStep) {
        this.evaluationTimeStep = evaluationTimeStep;
    }

    public void setProblems(Collection<Problem<PT>> problems) {
        this.problems = problems;
    }

    private void checkForSolutionCreator(GPGraphNode currentNode, Problem<PT> problem) {
        if (currentNode instanceof SolutionCreatorNode) {
            SolutionCreatorNode castedNode = (SolutionCreatorNode)currentNode;
            castedNode.setProblem(problem);
        } else if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            for (GPGraphNode nextNode : castedNode.getChildNodes()) {
                this.checkForSolutionCreator(nextNode, problem);
            }
        }
    }
}

