/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness.evaluation;

import java.util.Collection;
import org.apache.log4j.Logger;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPTrim;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPEvaluationTimerCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    static final Logger logger = Logger.getLogger(GPEvaluationTimerCachet.class);
    private final long evaluationTimeStep = 50L;
    private int runsPerProblem = 1;
    private long evaluationTime = 1000L;
    private Collection<Problem<PT>> problems;
    private Evaluator<ST, PT> evaluator;
    private boolean finishedCalculation = false;
    private boolean interrupted = false;
    private long lastRuntimeCalculation = 0L;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            solution.getCachets().add(new Cachet(1.0E8, "GPEvaluationTimerCachet"));
            return 1.0E8;
        }
        SolutionGene currentGene = (SolutionGene)solution.getSolutionGenes().get(0);
        ResultNode trimedGraph = GPTrim.trimGraph((ResultNode)((ResultNode)currentGene.getGene()));
        double quality = 0.0;
        for (Problem<PT> problem : this.problems) {
            int i;
            this.checkForSolutionCreator((GPGraphNode)trimedGraph, problem);
            double problemQuality = 0.0;
            long durationPerProblem = 0L;
            for (i = 0; i < this.runsPerProblem; ++i) {
                this.finishedCalculation = false;
                this.interrupted = false;
                Thread sleepThread = new Thread(() -> {
                    try {
                        for (long sleptFor = 0L; sleptFor < this.evaluationTime && !this.finishedCalculation; sleptFor += 50L) {
                            Thread.sleep(50L);
                        }
                        if (!this.finishedCalculation) {
                            this.interrupted = true;
                            BasicNodeUtil.interruptGraph((GPGraphNode)trimedGraph, (boolean)true);
                            logger.info((Object)"Interrupted execution of a gp-graph.");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });
                long duration = System.currentTimeMillis();
                sleepThread.start();
                Solution newSolution = null;
                try {
                    newSolution = (Solution)trimedGraph.execute();
                    this.finishedCalculation = true;
                }
                catch (Error e) {
                    System.gc();
                    this.interrupted = true;
                    logger.info((Object)("Had to stop execution because of: " + e.getClass().getName()));
                }
                duration = System.currentTimeMillis() - duration;
                durationPerProblem += Math.min(duration, this.evaluationTime);
                problemQuality = newSolution != null ? (problemQuality += this.evaluator.evaluateQuality(newSolution)) : (problemQuality += 100000.0);
                try {
                    sleepThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.interrupted) continue;
                problemQuality = 1000000.0;
                break;
            }
            quality += problemQuality / (double)(i + 1);
            this.lastRuntimeCalculation += durationPerProblem / (long)(i + 1);
        }
        this.lastRuntimeCalculation /= (long)this.problems.size();
        if ((quality /= (double)this.problems.size()) < 0.0 || quality > 1000000.0) {
            quality = 1000000.0;
        }
        solution.getCachets().add(new Cachet(quality, "GPEvaluationTimerCachet"));
        return quality;
    }

    public String getName() {
        return "GPEvaluationTimerCachet";
    }

    public void setRunsPerProblem(int runsPerProblem) {
        this.runsPerProblem = runsPerProblem;
    }

    public void setProblems(Collection<Problem<PT>> problems) {
        this.problems = problems;
    }

    public void setEvaluator(Evaluator<ST, PT> evaluator) {
        this.evaluator = evaluator;
    }

    public void setEvaluationTime(long evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public long getLastRuntimeCalculation() {
        return this.lastRuntimeCalculation;
    }

    private void checkForSolutionCreator(GPGraphNode currentNode, Problem<PT> problem) {
        if (currentNode instanceof SolutionCreatorNode) {
            SolutionCreatorNode castedNode = (SolutionCreatorNode)currentNode;
            castedNode.setProblem(problem);
        } else if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            for (GPGraphNode nextNode : castedNode.getChildNodes()) {
                this.checkForSolutionCreator(nextNode, problem);
            }
        }
    }
}

