/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness.evaluation;

import java.util.Collection;
import org.apache.log4j.Logger;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPTrim;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.problem.GPProblem;
import science.aist.machinelearning.problem.fitness.evaluation.GPEvaluationAbortingTimerCachet;

public class GPEvaluationLimitCreatorCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    static final Logger logger = Logger.getLogger(GPEvaluationAbortingTimerCachet.class);
    private int runsPerProblem = 1;
    private int maxSolutionCreations = 100000;
    private Collection<Problem<PT>> problems;
    private Evaluator<ST, PT> evaluator;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            return 1.0E8;
        }
        SolutionGene currentGene = (SolutionGene)solution.getSolutionGenes().get(0);
        double quality = 0.0;
        ResultNode trimedGraph = GPTrim.trimGraph((ResultNode)((ResultNode)currentGene.getGene()));
        if (BasicNodeUtil.solutionsCreatedByGraph((GPGraphNode)trimedGraph) > this.maxSolutionCreations) {
            solution.getCachets().add(new Cachet(1000000.0, "GPEvaluationLimitCreatorCachet"));
            return 1000000.0;
        }
        for (Problem<PT> problem : this.problems) {
            this.checkForSolutionCreator((GPGraphNode)trimedGraph, problem);
            double problemQuality = 0.0;
            for (int i = 0; i < this.runsPerProblem; ++i) {
                problemQuality += this.evaluator.evaluateQuality((Solution)trimedGraph.execute());
            }
            quality += problemQuality / (double)this.runsPerProblem;
        }
        solution.getCachets().add(new Cachet(quality, "GPEvaluationLimitCreatorCachet"));
        return quality;
    }

    public String getName() {
        return "GPEvaluationLimitCreatorCachet";
    }

    public void setRunsPerProblem(int runsPerProblem) {
        this.runsPerProblem = runsPerProblem;
    }

    public void setProblems(Collection<Problem<PT>> problems) {
        this.problems = problems;
    }

    public void setEvaluator(Evaluator<ST, PT> evaluator) {
        this.evaluator = evaluator;
    }

    public void setMaxSolutionCreations(int maxSolutionCreations) {
        this.maxSolutionCreations = maxSolutionCreations;
    }

    private void checkForSolutionCreator(GPGraphNode currentNode, Problem<PT> problem) {
        if (currentNode instanceof SolutionCreatorNode) {
            SolutionCreatorNode castedNode = (SolutionCreatorNode)currentNode;
            castedNode.setProblem(problem);
        } else if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            for (GPGraphNode nextNode : castedNode.getChildNodes()) {
                this.checkForSolutionCreator(nextNode, problem);
            }
        }
    }
}

