/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness.evaluation;

import java.util.Collection;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPEvaluationCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    private int runsPerProblem = 1;
    private Collection<Problem<PT>> problems;
    private Evaluator<ST, PT> evaluator;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            return 1000000.0;
        }
        SolutionGene currentGene = (SolutionGene)solution.getSolutionGenes().get(0);
        double quality = 0.0;
        for (Problem<PT> problem : this.problems) {
            this.checkForSolutionCreator((GPGraphNode)currentGene.getGene(), problem);
            double problemQuality = 0.0;
            for (int i = 0; i < this.runsPerProblem; ++i) {
                problemQuality += this.evaluator.evaluateQuality((Solution)((ResultNode)currentGene.getGene()).execute());
            }
            quality += problemQuality / (double)this.runsPerProblem;
        }
        if (quality < 0.0 || quality > 1000000.0) {
            quality = 1000000.0;
        }
        solution.getCachets().add(new Cachet(quality, "GPEvaluationCachet"));
        return quality;
    }

    public String getName() {
        return "GPEvaluationCachet";
    }

    public void setRunsPerProblem(int runsPerProblem) {
        this.runsPerProblem = runsPerProblem;
    }

    public void setProblems(Collection<Problem<PT>> problems) {
        this.problems = problems;
    }

    public void setEvaluator(Evaluator<ST, PT> evaluator) {
        this.evaluator = evaluator;
    }

    private void checkForSolutionCreator(GPGraphNode currentNode, Problem<PT> problem) {
        if (currentNode instanceof SolutionCreatorNode) {
            SolutionCreatorNode castedNode = (SolutionCreatorNode)currentNode;
            castedNode.setProblem(problem);
        } else if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            for (GPGraphNode nextNode : castedNode.getChildNodes()) {
                this.checkForSolutionCreator(nextNode, problem);
            }
        }
    }
}

