/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness.evaluation;

import java.util.Collection;
import org.apache.log4j.Logger;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.algorithm.gp.util.GPTrim;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPEvaluationAbortingTimerCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    static final Logger logger = Logger.getLogger(GPEvaluationAbortingTimerCachet.class);
    private final long evaluationTimeStep = 10L;
    private int runsPerProblem = 1;
    private long evaluationTime = 1000L;
    private Collection<Problem<PT>> problems;
    private Evaluator<ST, PT> evaluator;
    private Solution<ST, PT> newSolution = null;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            solution.getCachets().add(new Cachet(1000000.0, "GPEvaluationAbortingTimerCachet"));
            return 1000000.0;
        }
        SolutionGene currentGene = (SolutionGene)solution.getSolutionGenes().get(0);
        ResultNode trimedGraph = GPTrim.trimGraph((ResultNode)((ResultNode)currentGene.getGene()));
        double quality = 0.0;
        for (Problem<PT> problem : this.problems) {
            this.checkForSolutionCreator((GPGraphNode)trimedGraph, problem);
            double problemQuality = 0.0;
            this.newSolution = null;
            for (int i = 0; i < this.runsPerProblem; ++i) {
                Thread executionThread = new Thread(() -> {
                    try {
                        this.newSolution = (Solution)trimedGraph.execute();
                    }
                    catch (OutOfMemoryError e) {
                        logger.info((Object)"Had to stop execution because of OutOfMemoryError");
                    }
                });
                executionThread.start();
                for (long sleptFor = 0L; sleptFor < this.evaluationTime && this.newSolution == null; sleptFor += 10L) {
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.newSolution == null) {
                    executionThread.stop();
                    problemQuality = 1000000.0;
                    logger.info((Object)"Stopped execution of gp-graph-thread.");
                }
                problemQuality += this.evaluator.evaluateQuality(this.newSolution);
            }
            quality += problemQuality / (double)this.runsPerProblem;
        }
        solution.getCachets().add(new Cachet(quality, "GPEvaluationAbortingTimerCachet"));
        return quality;
    }

    public String getName() {
        return "GPEvaluationAbortingTimerCachet";
    }

    public void setRunsPerProblem(int runsPerProblem) {
        this.runsPerProblem = runsPerProblem;
    }

    public void setProblems(Collection<Problem<PT>> problems) {
        this.problems = problems;
    }

    public void setEvaluator(Evaluator<ST, PT> evaluator) {
        this.evaluator = evaluator;
    }

    public void setEvaluationTime(long evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    private void checkForSolutionCreator(GPGraphNode currentNode, Problem<PT> problem) {
        if (currentNode instanceof SolutionCreatorNode) {
            SolutionCreatorNode castedNode = (SolutionCreatorNode)currentNode;
            castedNode.setProblem(problem);
        } else if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            for (GPGraphNode nextNode : castedNode.getChildNodes()) {
                this.checkForSolutionCreator(nextNode, problem);
            }
        }
    }
}

