/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPNodeCostCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    private Map<Class, Double> costMap;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            solution.getCachets().add(new Cachet(1000000.0, "GPNodeCostCachet"));
            return 1000000.0;
        }
        double quality = this.evaluateQuality((GPGraphNode)((SolutionGene)solution.getSolutionGenes().get(0)).getGene(), this.costMap, new ArrayList<GPGraphNode>());
        if (quality < 0.0 || quality > 1000000.0) {
            quality = 1000000.0;
        }
        solution.getCachets().add(new Cachet(quality, "GPNodeCostCachets"));
        return quality;
    }

    public String getName() {
        return "GPNodeCostCachet";
    }

    private double evaluateQuality(GPGraphNode currentNode, Map<Class, Double> costMap, Collection<GPGraphNode> previousNodes) {
        if (!previousNodes.contains(currentNode)) {
            previousNodes.add(currentNode);
            double cost = costMap.get(currentNode.getClass());
            if (currentNode instanceof FunctionalGPGraphNode) {
                FunctionalGPGraphNode casted = (FunctionalGPGraphNode)currentNode;
                for (GPGraphNode nextNode : casted.getChildNodes()) {
                    cost += this.evaluateQuality(nextNode, costMap, previousNodes);
                }
            }
            return cost;
        }
        return 0.0;
    }

    public void setCostMap(Map<Class, Double> costMap) {
        this.costMap = costMap;
    }
}

