/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.fitness;

import java.util.ArrayList;
import java.util.Collection;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.problem.GPProblem;

public class GPDepthCachet<ST, PT>
implements CachetEvaluator<ResultNode, GPProblem> {
    private double quality = 0.0;

    public double evaluateQuality(Solution<ResultNode, GPProblem> solution) {
        if (solution == null || solution.getSolutionGenes() == null || solution.getSolutionGenes().size() == 0) {
            solution.getCachets().add(new Cachet(1000000.0, "GPDepthCachet"));
            return 1000000.0;
        }
        this.quality = 0.0;
        this.evaluateDepth((GPGraphNode)((SolutionGene)solution.getSolutionGenes().get(0)).getGene(), 0, new ArrayList<GPGraphNode>());
        if (this.quality < 0.0 || this.quality > 1000000.0) {
            this.quality = 1000000.0;
        }
        solution.getCachets().add(new Cachet(this.quality, "GPDepthCachet"));
        return this.quality;
    }

    public String getName() {
        return "GPDepthCachet";
    }

    private void evaluateDepth(GPGraphNode currentNode, int depth, Collection<GPGraphNode> previousNodes) {
        if (!previousNodes.contains(currentNode)) {
            previousNodes.add(currentNode);
            if ((double)depth > this.quality) {
                this.quality = depth;
            }
            if (currentNode instanceof FunctionalGPGraphNode) {
                FunctionalGPGraphNode casted = (FunctionalGPGraphNode)currentNode;
                for (GPGraphNode nextNode : casted.getChildNodes()) {
                    this.evaluateDepth(nextNode, depth + 1, previousNodes);
                }
            }
        }
    }
}

