/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.core.options.Descriptor;

public class GPProblem {
    private final Map<Class, ArrayList<GPGraphNode>> validGraphNodes;
    private final Map<Class, ArrayList<GPGraphNode>> terminalGraphNodes;
    private final Map<Class, ArrayList<GPGraphNode>> functionalGraphNodes;
    private final Map<Class, Map<String, Descriptor>> nodeSettings;

    public GPProblem(Map<Class, ArrayList<GPGraphNode>> validGraphNodes, Map<Class, Map<String, Descriptor>> nodeSettings) {
        this.validGraphNodes = validGraphNodes;
        this.nodeSettings = nodeSettings;
        this.terminalGraphNodes = new HashMap<Class, ArrayList<GPGraphNode>>();
        this.functionalGraphNodes = new HashMap<Class, ArrayList<GPGraphNode>>();
        for (Map.Entry<Class, ArrayList<GPGraphNode>> entry : validGraphNodes.entrySet()) {
            ArrayList<GPGraphNode> terminals = new ArrayList<GPGraphNode>();
            ArrayList<GPGraphNode> functionals = new ArrayList<GPGraphNode>();
            this.terminalGraphNodes.put(entry.getKey(), terminals);
            this.functionalGraphNodes.put(entry.getKey(), functionals);
            for (GPGraphNode node : entry.getValue()) {
                if (!(node instanceof FunctionalGPGraphNode)) {
                    terminals.add(node);
                    continue;
                }
                functionals.add(node);
            }
        }
    }

    public GPProblem(Map<Class, ArrayList<GPGraphNode>> validGraphNodes, Map<Class, Map<String, Descriptor>> nodeSettings, Map<Class, ArrayList<GPGraphNode>> additionalTerminals) {
        this(validGraphNodes, nodeSettings);
        for (Map.Entry<Class, ArrayList<GPGraphNode>> entry : this.terminalGraphNodes.entrySet()) {
            ArrayList<GPGraphNode> terminals = entry.getValue();
            ArrayList<GPGraphNode> additional = additionalTerminals.get(entry.getKey());
            if (additional == null) continue;
            terminals.addAll(additional);
        }
    }

    public Map<Class, ArrayList<GPGraphNode>> getValidGraphNodes() {
        return this.validGraphNodes;
    }

    public Map<Class, ArrayList<GPGraphNode>> getTerminalGraphNodes() {
        return this.terminalGraphNodes;
    }

    public Map<Class, Map<String, Descriptor>> getNodeSettings() {
        return this.nodeSettings;
    }

    public Map<Class, ArrayList<GPGraphNode>> getFunctionalGraphNodes() {
        return this.functionalGraphNodes;
    }
}

