/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.mutation;

import java.util.Random;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.ValueContainer;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.mutation.RollbackRandomNGenesMutator;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.problem.GPProblem;

public class GPValueMutator
extends RollbackRandomNGenesMutator<ResultNode, GPProblem> {
    private final Random r = new Random();
    private Double changeByMax = 0.5;

    protected SolutionGene<ResultNode, GPProblem> createGeneByMutation(SolutionGene<ResultNode, GPProblem> gene) {
        SolutionGene mutation = new SolutionGene();
        mutation.setProblemGenes(gene.getProblemGenes());
        ResultNode root = BasicNodeUtil.deepCopyForGraph((ResultNode)((ResultNode)gene.getGene()));
        this.findAndChangeValueContainer((GPGraphNode)root.getChildNodes().get(0));
        mutation.setGene((Object)root);
        return mutation;
    }

    public void setChangeByMax(Double changeByMax) {
        this.changeByMax = changeByMax;
    }

    private void findAndChangeValueContainer(GPGraphNode node) {
        if (node instanceof ValueContainer) {
            Number value;
            ValueContainer nodeWithValue = (ValueContainer)node;
            if (nodeWithValue.getValue().getClass().equals(Boolean.class)) {
                nodeWithValue.setValue((Object)((Boolean)nodeWithValue.getValue() == false ? 1 : 0));
            } else if (nodeWithValue.getValue().getClass().equals(Double.class)) {
                value = (Double)nodeWithValue.getValue();
                value = (Double)value + this.changeByMax * (Double)value * this.r.nextDouble() * (double)(this.r.nextBoolean() ? 1 : -1);
                nodeWithValue.setValue((Object)value);
            } else if (nodeWithValue.getValue().getClass().equals(Float.class)) {
                value = (Float)nodeWithValue.getValue();
                value = Float.valueOf(((Float)value).floatValue() + this.changeByMax.floatValue() * ((Float)value).floatValue() * this.r.nextFloat() * (float)(this.r.nextBoolean() ? 1 : -1));
                nodeWithValue.setValue((Object)value);
            } else if (nodeWithValue.getValue().getClass().equals(Integer.class)) {
                value = (Integer)nodeWithValue.getValue();
                value = (Integer)value + Double.valueOf(this.changeByMax * (double)((Integer)value).intValue() * this.r.nextDouble() * (double)(this.r.nextBoolean() ? 1 : -1)).intValue();
                nodeWithValue.setValue((Object)value);
            }
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode functionalNode = (FunctionalGPGraphNode)node;
            for (GPGraphNode child : functionalNode.getChildNodes()) {
                this.findAndChangeValueContainer(child);
            }
        }
    }
}

