/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.mutation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPRepair;
import science.aist.machinelearning.algorithm.mutation.RollbackRandomNGenesMutator;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.problem.GPProblem;

public class GPReplacingNodeMutator
extends RollbackRandomNGenesMutator<ResultNode, GPProblem> {
    private final Random r = new Random();
    private GPRepair repair = null;

    protected SolutionGene<ResultNode, GPProblem> createGeneByMutation(SolutionGene<ResultNode, GPProblem> gene) {
        SolutionGene mutation = new SolutionGene();
        mutation.setProblemGenes(gene.getProblemGenes());
        ResultNode root = BasicNodeUtil.deepCopyForGraph((ResultNode)((ResultNode)gene.getGene()));
        int indexOfNodeToReplace = this.r.nextInt(BasicNodeUtil.numberOfNodesInGraph((GPGraphNode)root) - 1) + 1;
        ArrayList<GPGraphNode> nodes = new ArrayList<GPGraphNode>();
        this.findNodeWithIndex((GPGraphNode)root, nodes, indexOfNodeToReplace);
        GPGraphNode replaceMe = (GPGraphNode)nodes.get(nodes.size() - 1);
        this.removeSpecificChild((GPGraphNode)root, new ArrayList<GPGraphNode>(), replaceMe);
        GPProblem problem = (GPProblem)((ProblemGene)gene.getProblemGenes().get(0)).getGene();
        try {
            this.repair.repairGraph((GPGraphNode)root, problem.getValidGraphNodes(), problem.getTerminalGraphNodes(), problem.getFunctionalGraphNodes(), problem.getNodeSettings());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        mutation.setGene((Object)root);
        return mutation;
    }

    private void findNodeWithIndex(GPGraphNode startFrom, List<GPGraphNode> visitedNodes, int stopAt) {
        visitedNodes.add(startFrom);
        if (visitedNodes.size() == stopAt && startFrom instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)startFrom;
            for (GPGraphNode child : castedNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                this.findNodeWithIndex(child, visitedNodes, stopAt);
            }
        }
    }

    private void removeSpecificChild(GPGraphNode node, List<GPGraphNode> visitedNodes, GPGraphNode childToRemove) {
        visitedNodes.add(node);
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            Iterator iterator = castedNode.getChildNodes().iterator();
            while (iterator.hasNext()) {
                GPGraphNode child = (GPGraphNode)iterator.next();
                if (child == childToRemove) {
                    iterator.remove();
                    continue;
                }
                if (visitedNodes.contains(child)) continue;
                this.removeSpecificChild(child, visitedNodes, childToRemove);
            }
        }
    }

    public void setRepair(GPRepair repair) {
        this.repair = repair;
    }
}

