/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.crossover;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.algorithm.ga.Crossover;
import science.aist.machinelearning.algorithm.ga.Selector;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPValidator;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.problem.GPProblem;

public class GPCrossover
implements Crossover<ResultNode, GPProblem> {
    private final Random r = new Random();

    public Solution<ResultNode, GPProblem> breed(List<Solution<ResultNode, GPProblem>> population, Selector<ResultNode, GPProblem> selector) {
        if (population != null && population.size() > 0 && selector != null) {
            if (population.size() == 1) {
                return population.get(0);
            }
            Solution a = selector.select(population);
            Solution b = selector.select(population);
            ResultNode aRoot = BasicNodeUtil.deepCopyForGraph((ResultNode)((ResultNode)((SolutionGene)a.getSolutionGenes().get(0)).getGene()));
            ResultNode bRoot = BasicNodeUtil.deepCopyForGraph((ResultNode)((ResultNode)((SolutionGene)b.getSolutionGenes().get(0)).getGene()));
            Map typesOfA = BasicNodeUtil.nodesWithReturnType((GPGraphNode)aRoot);
            Map typesOfB = BasicNodeUtil.nodesWithReturnType((GPGraphNode)bRoot);
            if (typesOfA.keySet().size() == 0 || typesOfB.keySet().size() == 0) {
                return population.get(this.r.nextInt(2));
            }
            ArrayList classesToShuffle = new ArrayList(typesOfA.keySet());
            Collections.shuffle(classesToShuffle);
            Class sharedClass = null;
            for (Class clazz : classesToShuffle) {
                if (!typesOfB.containsKey(clazz)) continue;
                sharedClass = clazz;
                break;
            }
            if (sharedClass == null) {
                return population.get(this.r.nextInt(2));
            }
            ArrayList aNodes = (ArrayList)typesOfA.get(sharedClass);
            GPGraphNode aNode = (GPGraphNode)aNodes.get(this.r.nextInt(aNodes.size()));
            ArrayList bNodes = (ArrayList)typesOfB.get(sharedClass);
            GPGraphNode bNode = (GPGraphNode)bNodes.get(this.r.nextInt(bNodes.size()));
            this.replaceAllNodesWithOtherNode((GPGraphNode)aRoot, aNode, bNode, new ArrayList<GPGraphNode>());
            if (!GPValidator.validateGraph((GPGraphNode)aRoot)) {
                GPValidator.validateGraph((GPGraphNode)aRoot);
                return population.get(this.r.nextInt(2));
            }
            Solution crossoverSolution = new Solution();
            List problemGenes = ((SolutionGene)a.getSolutionGenes().get(0)).getProblemGenes();
            crossoverSolution.addGene(new SolutionGene((Object)aRoot, problemGenes));
            return crossoverSolution;
        }
        return null;
    }

    private void replaceAllNodesWithOtherNode(GPGraphNode currentNode, GPGraphNode replaceNode, GPGraphNode substituteNode, Collection<GPGraphNode> visitedNodes) {
        if (currentNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)currentNode;
            ListIterator<GPGraphNode> iterator = castedNode.getChildNodes().listIterator();
            while (iterator.hasNext()) {
                GPGraphNode child = (GPGraphNode)iterator.next();
                if (child == replaceNode) {
                    iterator.set(substituteNode);
                }
                if (visitedNodes.contains(child)) continue;
                visitedNodes.add(child);
                this.replaceAllNodesWithOtherNode(child, replaceNode, substituteNode, visitedNodes);
            }
        }
    }
}

