/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import science.aist.machinelearning.algorithm.mapping.WeightCalculator;

public class AStarImpl<NT, WT extends Number> {
    public List<NT> findShortestPath(Map<NT, Map<NT, WT>> graph, NT from, Predicate<NT> to, Comparator<Number> comparator, WeightCalculator<NT, WT> weightCalculator) {
        HashSet closed = new HashSet();
        HashSet open = new HashSet();
        open.add(from);
        HashMap cameFrom = new HashMap();
        HashMap accumulatedWeights = new HashMap();
        accumulatedWeights.put(from, 0.0);
        while (!open.isEmpty()) {
            Object currentNode = this.pollLowest(open, accumulatedWeights, comparator);
            if (to.test(currentNode)) {
                return this.reconstructPath(cameFrom, currentNode);
            }
            closed.add(currentNode);
            graph.get(currentNode).forEach((neighbor, weight) -> {
                if (!closed.contains(neighbor)) {
                    open.add(neighbor);
                    Number weightToNeighbor = (Number)accumulatedWeights.get(neighbor);
                    Number newNeighborWeight = (Number)weightCalculator.weight((Number)accumulatedWeights.get(currentNode), weight.doubleValue(), (Number)weightCalculator.estimatedWeight(currentNode, neighbor, graph));
                    if (weightToNeighbor == null || comparator.compare(weightToNeighbor, newNeighborWeight) > 0) {
                        cameFrom.put(neighbor, currentNode);
                        accumulatedWeights.put((Object)neighbor, (Double)newNeighborWeight);
                    }
                }
            });
        }
        return new ArrayList();
    }

    private List<NT> reconstructPath(Map<NT, NT> cameFrom, NT currentNode) {
        ArrayList<NT> path = new ArrayList<NT>();
        while (currentNode != null) {
            path.add(0, currentNode);
            currentNode = cameFrom.get(currentNode);
        }
        return path;
    }

    private NT pollLowest(Set<NT> open, Map<NT, Number> accumulatedWeights, Comparator<Number> comparator) {
        if (open.isEmpty()) {
            throw new IllegalStateException("open may not be empty");
        }
        Object lowest = null;
        boolean firstRound = true;
        for (Object object : open) {
            if (firstRound) {
                firstRound = false;
                lowest = object;
                continue;
            }
            if (comparator.compare(accumulatedWeights.get(lowest), accumulatedWeights.get(object)) <= 0) continue;
            lowest = object;
        }
        open.remove(lowest);
        return (NT)lowest;
    }
}

