/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import science.aist.machinelearning.algorithm.gene.ShortestPathProblemGene;
import science.aist.machinelearning.algorithm.mapping.AStarGeneCreator;
import science.aist.machinelearning.algorithm.mapping.WeightCalculator;
import science.aist.machinelearning.core.AbstractAlgorithm;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.mapping.OneToOneSolutionCreator;
import science.aist.machinelearning.core.mapping.SolutionCreator;
import science.aist.machinelearning.core.options.Descriptor;

public class AStar<NT, WT extends Number>
extends AbstractAlgorithm<List<NT>, ShortestPathProblemGene<NT, WT>> {
    private final SolutionCreator<List<NT>, ShortestPathProblemGene<NT, WT>> solutionCreator = new OneToOneSolutionCreator();
    private final Map<String, Descriptor> specificOptions = new HashMap<String, Descriptor>();

    public AStar() {
        Comparator<Number> comparator = Comparator.comparingDouble(Number::doubleValue);
        Descriptor descriptor = new Descriptor(comparator);
        this.specificOptions.put("comparator", descriptor);
        WeightCalculator weightCalculator = new WeightCalculator<NT, Number>(){

            @Override
            public Number weight(Number accumulatedWeight, Number weightForOneNode, Number estimatedWeight) {
                return accumulatedWeight.doubleValue() + weightForOneNode.doubleValue() + estimatedWeight.doubleValue();
            }

            @Override
            public Number estimatedWeight(NT from, NT to, Map<NT, Map<NT, Number>> graph) {
                return 0;
            }
        };
        Descriptor weightCalculatorDescriptor = new Descriptor((Object)weightCalculator);
        this.specificOptions.put("weightCalculator", weightCalculatorDescriptor);
    }

    protected Map<String, Descriptor> getSpecificOptions() {
        return this.specificOptions;
    }

    protected boolean setSpecificOption(String s, Descriptor descriptor) {
        if (s.equals("comparator") && descriptor != null) {
            this.specificOptions.put(s, descriptor);
            return true;
        }
        if (s.equals("weightCalculator") && descriptor != null) {
            this.specificOptions.put(s, descriptor);
        }
        return false;
    }

    public Solution<List<NT>, ShortestPathProblemGene<NT, WT>> solve(Problem<ShortestPathProblemGene<NT, WT>> problem) {
        AStarGeneCreator geneCreator = new AStarGeneCreator();
        geneCreator.setOptions(this.specificOptions);
        this.solutionCreator.setGeneCreator(geneCreator);
        return this.solutionCreator.createSolution(problem);
    }

    public Solution<List<NT>, ShortestPathProblemGene<NT, WT>> solve(Problem<ShortestPathProblemGene<NT, WT>> problem, Solution<List<NT>, ShortestPathProblemGene<NT, WT>> solution) {
        AStarGeneCreator geneCreator = new AStarGeneCreator();
        geneCreator.setOptions(this.specificOptions);
        this.solutionCreator.setGeneCreator(geneCreator);
        return this.solutionCreator.createSolution(problem);
    }
}

