/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.amalgam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import science.aist.machinelearning.core.AbstractAlgorithm;
import science.aist.machinelearning.core.Algorithm;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.options.Descriptor;

public class AmalgamAlgorithm<GT, PT>
extends AbstractAlgorithm<GT, PT> {
    private static final Logger logger = Logger.getLogger(AmalgamAlgorithm.class);
    private List<Algorithm<GT, PT>> algorithms = new ArrayList<Algorithm<GT, PT>>();

    public Solution<GT, PT> solve(Problem<PT> problem) {
        return this.solve(problem, null);
    }

    public Solution<GT, PT> solve(Problem<PT> problem, Solution<GT, PT> bestSolution) {
        if (problem == null) {
            return null;
        }
        int start = 0;
        if (bestSolution == null) {
            logger.debug((Object)("Starting to get a first best solution with: " + this.algorithms.get(0).getClass().getCanonicalName()));
            bestSolution = this.algorithms.get(0).solve(problem);
            ++start;
        }
        for (Algorithm<GT, PT> algorithm : this.algorithms.subList(start, this.algorithms.size())) {
            logger.debug((Object)("Starting to search with: " + algorithm.getClass().getCanonicalName()));
            bestSolution = algorithm.solve(problem, bestSolution);
        }
        logger.debug((Object)"Found best mapping");
        return bestSolution;
    }

    public void setAlgorithms(List<Algorithm<GT, PT>> algorithms) {
        this.algorithms = algorithms;
    }

    protected Map<String, Descriptor> getSpecificOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("algorithms", new Descriptor(this.algorithms));
        return options;
    }

    protected boolean setSpecificOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("algorithms")) {
                this.setAlgorithms((List)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

