/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoxes.renderer;

import java.util.List;
import java.util.function.Function;
import org.hl7.fhir.r5.model.AuditEvent;
import science.aist.gtf.transformation.renderer.TransformationRender;
import science.aist.xes.model.AttributeStringType;
import science.aist.xes.model.EventType;
import science.aist.xes.model.ObjectFactory;
import science.aist.xes.model.TraceType;

public class TraceRenderer
implements TransformationRender<TraceType, TraceType, List<AuditEvent>, List<AuditEvent>> {
    private final ObjectFactory factory;
    private final TransformationRender<EventType, EventType, List<AuditEvent>, AuditEvent> eventRenderer;
    private final Function<AuditEvent, String> conceptNameResolver;

    public TraceType renderElement(List<AuditEvent> auditEvents, List<AuditEvent> currentElement) {
        return this.mapProperties(this.createElement(), auditEvents, currentElement);
    }

    public TraceType createElement() {
        return this.factory.createTraceType();
    }

    public TraceType mapProperties(TraceType traceType, List<AuditEvent> auditEvents, List<AuditEvent> currentElement) {
        if (currentElement.isEmpty()) {
            return traceType;
        }
        AttributeStringType attributeStringType = this.factory.createAttributeStringType();
        attributeStringType.setKey("concept:name");
        attributeStringType.setValue(this.conceptNameResolver.apply(currentElement.get(0)));
        traceType.getStringOrDateOrInt().add(attributeStringType);
        currentElement.stream().map(auditEvent -> (EventType)this.eventRenderer.renderElement((Object)currentElement, auditEvent)).forEach(traceType.getEvent()::add);
        return traceType;
    }

    public TraceRenderer(ObjectFactory factory, TransformationRender<EventType, EventType, List<AuditEvent>, AuditEvent> eventRenderer, Function<AuditEvent, String> conceptNameResolver) {
        this.factory = factory;
        this.eventRenderer = eventRenderer;
        this.conceptNameResolver = conceptNameResolver;
    }
}

