/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoxes.renderer;

import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.hl7.fhir.r5.model.AuditEvent;
import science.aist.fhirauditeventtoxes.DateUtil;
import science.aist.gtf.transformation.renderer.TransformationRender;
import science.aist.xes.model.AttributeDateType;
import science.aist.xes.model.AttributeStringType;
import science.aist.xes.model.EventType;
import science.aist.xes.model.ObjectFactory;

public class EventRenderer
implements TransformationRender<EventType, EventType, List<AuditEvent>, AuditEvent> {
    private final ObjectFactory factory;
    private final Function<AuditEvent, String> conceptNameResolver;

    public EventType renderElement(List<AuditEvent> auditEvents, AuditEvent currentElement) {
        return this.mapProperties(this.createElement(), auditEvents, currentElement);
    }

    public EventType createElement() {
        return this.factory.createEventType();
    }

    public EventType mapProperties(EventType eventType, List<AuditEvent> auditEvents, AuditEvent currentElement) {
        AttributeStringType conceptName = this.factory.createAttributeStringType();
        conceptName.setKey("concept:name");
        conceptName.setValue(this.conceptNameResolver.apply(currentElement));
        eventType.getStringOrDateOrInt().add(conceptName);
        AttributeDateType timestamp = this.factory.createAttributeDateType();
        timestamp.setKey("time:timestamp");
        timestamp.setValue(DateUtil.dateToGregorianCalendar((Date)currentElement.getOccurredDateTimeType().getValue()));
        eventType.getStringOrDateOrInt().add(timestamp);
        AttributeStringType lifecycleTransition = this.factory.createAttributeStringType();
        lifecycleTransition.setKey("lifecycle:transition");
        lifecycleTransition.setValue("complete");
        eventType.getStringOrDateOrInt().add(lifecycleTransition);
        return eventType;
    }

    public EventRenderer(ObjectFactory factory, Function<AuditEvent, String> conceptNameResolver) {
        this.factory = factory;
        this.conceptNameResolver = conceptNameResolver;
    }
}

