/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoxes.renderer;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r5.model.AuditEvent;
import science.aist.fhirauditeventtoxes.domain.AuditEventBundle;
import science.aist.gtf.transformation.renderer.TransformationRender;
import science.aist.xes.model.AttributeStringType;
import science.aist.xes.model.ExtensionType;
import science.aist.xes.model.LogType;
import science.aist.xes.model.ObjectFactory;
import science.aist.xes.model.TraceType;

public class LogRenderer
implements TransformationRender<LogType, LogType, AuditEventBundle, Collection<AuditEvent>> {
    private final ObjectFactory factory;
    private final TransformationRender<TraceType, TraceType, List<AuditEvent>, List<AuditEvent>> traceRenderer;
    private final Function<AuditEvent, ?> groupingSelector;

    public LogType renderElement(AuditEventBundle auditEventBundle, Collection<AuditEvent> currentElement) {
        return this.mapProperties(this.createElement(), auditEventBundle, currentElement);
    }

    public LogType createElement() {
        return this.factory.createLogType();
    }

    public LogType mapProperties(LogType logType, AuditEventBundle auditEventBundle, Collection<AuditEvent> currentElement) {
        logType.setXesVersion(BigDecimal.valueOf(1.0));
        Stream.of(this.timeExtension(), this.lifecycleExtension(), this.conceptExtension()).forEach(logType.getExtension()::add);
        AttributeStringType conceptName = this.factory.createAttributeStringType();
        conceptName.setKey("concept:name");
        conceptName.setValue(auditEventBundle.getPlanDefinition());
        logType.getStringOrDateOrInt().add(conceptName);
        currentElement.stream().collect(Collectors.groupingBy(this.groupingSelector)).forEach((ignore, events) -> logType.getTrace().add((TraceType)this.traceRenderer.renderElement(events, events)));
        return logType;
    }

    private ExtensionType timeExtension() {
        return this.createExtension("Time", "time", "http://www.xes-standard.org/time.xesext");
    }

    private ExtensionType lifecycleExtension() {
        return this.createExtension("Lifecycle", "lifecycle", "http://www.xes-standard.org/lifecycle.xesext");
    }

    private ExtensionType conceptExtension() {
        return this.createExtension("Concept", "concept", "http://www.xes-standard.org/concept.xesext");
    }

    private ExtensionType createExtension(String name, String prefix, String uri) {
        ExtensionType conceptExtension = this.factory.createExtensionType();
        conceptExtension.setName(name);
        conceptExtension.setPrefix(prefix);
        conceptExtension.setUri(uri);
        return conceptExtension;
    }

    public LogRenderer(ObjectFactory factory, TransformationRender<TraceType, TraceType, List<AuditEvent>, List<AuditEvent>> traceRenderer, Function<AuditEvent, ?> groupingSelector) {
        this.factory = factory;
        this.traceRenderer = traceRenderer;
        this.groupingSelector = groupingSelector;
    }
}

