/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoxes;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Bundle;
import science.aist.fhirauditeventtoxes.FhirAuditEventsToXESLogTransformer;
import science.aist.fhirauditeventtoxes.ReflectionUtil;
import science.aist.fhirauditeventtoxes.domain.AuditEventBundle;
import science.aist.fhirauditeventtoxes.renderer.EventRenderer;
import science.aist.fhirauditeventtoxes.renderer.LogRenderer;
import science.aist.fhirauditeventtoxes.renderer.TraceRenderer;
import science.aist.gtf.transformation.Transformer;
import science.aist.xes.model.LogType;
import science.aist.xes.model.ObjectFactory;
import science.aist.xes.model.impl.LogRepository;

public class FhirAuditEventsToXESLogService {
    private final ObjectFactory factory = new ObjectFactory();
    private final Transformer<AuditEventBundle, LogType> transformer;

    public FhirAuditEventsToXESLogService() {
        this((AuditEvent ae) -> ae.getEncounter().getReference(), (AuditEvent ae) -> ae.getCode().getCodingFirstRep().getDisplay());
    }

    public FhirAuditEventsToXESLogService(String traceConceptNameResolverPath, String eventConceptNameResolverPath) {
        this(ReflectionUtil.createFunctionChain(AuditEvent.class, traceConceptNameResolverPath), ReflectionUtil.createFunctionChain(AuditEvent.class, eventConceptNameResolverPath));
    }

    public FhirAuditEventsToXESLogService(Function<AuditEvent, String> traceConceptNameResolver, Function<AuditEvent, String> eventConceptNameResolver) {
        EventRenderer eventRenderer = new EventRenderer(this.factory, eventConceptNameResolver);
        TraceRenderer traceRenderer = new TraceRenderer(this.factory, eventRenderer, traceConceptNameResolver);
        LogRenderer logRenderer = new LogRenderer(this.factory, traceRenderer, traceConceptNameResolver);
        this.transformer = new FhirAuditEventsToXESLogTransformer(logRenderer);
    }

    public LogType convertFhirAuditEventsToXESLog(AuditEventBundle bundle) {
        return (LogType)this.transformer.applyTransformation((Object)bundle);
    }

    public void convertFhirAuditEventsToXESLog(InputStream auditBundleInputStream, String planDefinition, OutputStream logOutputStream) {
        FhirContext ctx = FhirContext.forR5();
        IParser parser = ctx.newJsonParser();
        Bundle auditEventBundle = (Bundle)parser.parseResource(Bundle.class, auditBundleInputStream);
        Collection auditEvents = auditEventBundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).map(AuditEvent.class::cast).collect(Collectors.toList());
        LogType logType = this.convertFhirAuditEventsToXESLog(new AuditEventBundle(planDefinition, auditEvents));
        LogRepository repository = new LogRepository();
        repository.save(this.factory.createLog(logType), logOutputStream);
    }
}

