/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoocel.renderer;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Reference;
import science.aist.gtf.transformation.renderer.TransformationRender;
import science.aist.jack.stream.FilterStreamUtils;
import science.aist.ocel.model.EventType;
import science.aist.ocel.model.EventsType;
import science.aist.ocel.model.LogType;
import science.aist.ocel.model.ObjectFactory;
import science.aist.ocel.model.ObjectType;
import science.aist.ocel.model.ObjectsType;

public class LogTypeRenderer
implements TransformationRender<LogType, LogType, Collection<AuditEvent>, Collection<AuditEvent>> {
    private final ObjectFactory factory;
    private final TransformationRender<EventType, EventType, Collection<AuditEvent>, AuditEvent> eventRenderer;
    private final TransformationRender<ObjectType, ObjectType, Collection<AuditEvent>, Reference> objectRenderer;

    public LogType renderElement(Collection<AuditEvent> auditEvents, Collection<AuditEvent> currentElement) {
        return this.mapProperties(this.createElement(), auditEvents, currentElement);
    }

    public LogType createElement() {
        return this.factory.createLogType();
    }

    public LogType mapProperties(LogType logType, Collection<AuditEvent> auditEvents, Collection<AuditEvent> currentElement) {
        EventsType eventsType = this.factory.createEventsType();
        currentElement.stream().map(ae -> (EventType)this.eventRenderer.renderElement((Object)currentElement, ae)).forEach(eventsType.getEvent()::add);
        logType.getEvents().add(eventsType);
        ObjectsType objectsType = this.factory.createObjectsType();
        currentElement.stream().flatMap(ae -> Stream.of(ae.getBasedOn().stream(), Stream.of(ae.getEncounter()), ae.getAgent().stream().map(AuditEvent.AuditEventAgentComponent::getWho))).flatMap(s -> s).filter(FilterStreamUtils.distinctByKeys((Function[])new Function[]{Reference::getReference})).sorted(Comparator.comparing(r -> r.getReferenceElement().getResourceType()).thenComparing(r -> r.getReferenceElement().getIdPartAsLong())).map(ref -> (ObjectType)this.objectRenderer.renderElement((Object)currentElement, ref)).forEach(objectsType.getObject()::add);
        logType.getObjects().add(objectsType);
        return logType;
    }

    public LogTypeRenderer(ObjectFactory factory, TransformationRender<EventType, EventType, Collection<AuditEvent>, AuditEvent> eventRenderer, TransformationRender<ObjectType, ObjectType, Collection<AuditEvent>, Reference> objectRenderer) {
        this.factory = factory;
        this.eventRenderer = eventRenderer;
        this.objectRenderer = objectRenderer;
    }
}

