/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoocel.renderer;

import java.util.Collection;
import java.util.stream.Stream;
import org.hl7.fhir.r5.model.AuditEvent;
import science.aist.fhirauditeventtoocel.AttributeTypeHelper;
import science.aist.gtf.transformation.renderer.TransformationRender;
import science.aist.ocel.model.EventType;
import science.aist.ocel.model.ObjectFactory;

public class EventTypeRenderer
implements TransformationRender<EventType, EventType, Collection<AuditEvent>, AuditEvent> {
    private final ObjectFactory factory;

    public EventType renderElement(Collection<AuditEvent> auditEvents, AuditEvent currentElement) {
        return this.mapProperties(this.createElement(), auditEvents, currentElement);
    }

    public EventType createElement() {
        return this.factory.createEventType();
    }

    public EventType mapProperties(EventType eventType, Collection<AuditEvent> auditEvents, AuditEvent currentElement) {
        eventType.getStringOrDateOrInt().add(AttributeTypeHelper.string("id", currentElement.getId()));
        eventType.getStringOrDateOrInt().add(AttributeTypeHelper.string("activity", currentElement.getCode().getCodingFirstRep().getDisplay()));
        eventType.getStringOrDateOrInt().add(AttributeTypeHelper.date("timestamp", currentElement.getOccurredPeriod().getStart()));
        eventType.getStringOrDateOrInt().add(AttributeTypeHelper.list("omap", Stream.of(currentElement.getBasedOn().stream(), Stream.of(currentElement.getEncounter()), currentElement.getAgent().stream().map(AuditEvent.AuditEventAgentComponent::getWho)).flatMap(s -> s).map(ref -> AttributeTypeHelper.string("object-id", ref.getReference()))));
        return eventType;
    }

    public EventTypeRenderer(ObjectFactory factory) {
        this.factory = factory;
    }
}

