/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoocel;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Bundle;
import science.aist.fhirauditeventtoocel.FhirAuditEventsToOCELLogTransformer;
import science.aist.fhirauditeventtoocel.renderer.EventTypeRenderer;
import science.aist.fhirauditeventtoocel.renderer.LogTypeRenderer;
import science.aist.fhirauditeventtoocel.renderer.ReferenceObjectTypeRenderer;
import science.aist.gtf.transformation.Transformer;
import science.aist.ocel.model.LogType;
import science.aist.ocel.model.ObjectFactory;
import science.aist.ocel.model.impl.LogRepository;

public class FhirAuditEventsToOCELLogService {
    private final ObjectFactory factory = new ObjectFactory();
    private final Transformer<Collection<AuditEvent>, LogType> transformer = new FhirAuditEventsToOCELLogTransformer(new LogTypeRenderer(this.factory, new EventTypeRenderer(this.factory), new ReferenceObjectTypeRenderer(this.factory)));

    public LogType convertFhirAuditEventsToOCELLog(Collection<AuditEvent> auditEvents) {
        return (LogType)this.transformer.applyTransformation(auditEvents);
    }

    public void convertFhirAuditEventsToOCELLog(InputStream auditBundleInputStream, OutputStream logOutputStream) {
        FhirContext ctx = FhirContext.forR5();
        IParser parser = ctx.newJsonParser();
        Bundle auditEventBundle = (Bundle)parser.parseResource(Bundle.class, auditBundleInputStream);
        Collection auditEvents = auditEventBundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).map(AuditEvent.class::cast).collect(Collectors.toList());
        LogType logType = this.convertFhirAuditEventsToOCELLog(auditEvents);
        LogRepository repository = new LogRepository();
        repository.save(this.factory.createLog(logType), logOutputStream);
    }
}

