/*
 * Decompiled with CFR 0.152.
 */
package science.aist.fhirauditeventtoocel;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import science.aist.ocel.model.AttributeDateType;
import science.aist.ocel.model.AttributeListType;
import science.aist.ocel.model.AttributeStringType;
import science.aist.ocel.model.AttributeType;
import science.aist.ocel.model.ObjectFactory;

public final class AttributeTypeHelper {
    private static final ObjectFactory FACTORY = new ObjectFactory();

    public static AttributeStringType string(String key, String value) {
        AttributeStringType attributeStringType = FACTORY.createAttributeStringType();
        attributeStringType.setKey(key);
        attributeStringType.setValue(value);
        return attributeStringType;
    }

    public static AttributeDateType date(String key, Date date) {
        AttributeDateType attributeDateType = FACTORY.createAttributeDateType();
        attributeDateType.setKey(key);
        attributeDateType.setValue(AttributeTypeHelper.dateToGregorianCalendar(date));
        return attributeDateType;
    }

    public static AttributeListType list(String key, Stream<AttributeType> elements) {
        AttributeListType attributeListType = FACTORY.createAttributeListType();
        attributeListType.setKey(key);
        elements.forEach(attributeListType.getStringOrDateOrInt()::add);
        return attributeListType;
    }

    public static XMLGregorianCalendar dateToGregorianCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
    }

    private AttributeTypeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

