/*
 * Decompiled with CFR 0.152.
 */
package saschpe.log4k;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import saschpe.log4k.ConsoleLogger$WhenMappings;
import saschpe.log4k.Log;
import saschpe.log4k.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\t*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lsaschpe/log4k/ConsoleLogger;", "Lsaschpe/log4k/Logger;", "()V", "javaLogger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "levelMap", "Ljava/util/HashMap;", "Lsaschpe/log4k/Log$Level;", "", "Lkotlin/collections/HashMap;", "stackTraceString", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "getTraceTag", "trace", "Ljava/lang/StackTraceElement;", "print", "", "level", "tag", "message", "throwable", "log4k"})
public final class ConsoleLogger
extends Logger {
    private final java.util.logging.Logger javaLogger;
    private final HashMap<Log.Level, String> levelMap;

    @Override
    protected void print(@NotNull Log.Level level, @NotNull String tag, @Nullable String message, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        StackTraceElement trace = new Exception().getStackTrace()[5];
        String logTag = tag;
        CharSequence charSequence = tag;
        boolean bl = false;
        if (charSequence.length() == 0) {
            StackTraceElement stackTraceElement = trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"trace");
            logTag = this.getTraceTag(stackTraceElement);
        }
        String fullMessage = String.valueOf(message);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable throwable3 = throwable2;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable it = throwable3;
            boolean bl4 = false;
            fullMessage = fullMessage + '\n' + this.getStackTraceString(it);
        }
        String msg = this.levelMap.get((Object)level) + ' ' + logTag + ": " + fullMessage;
        switch (ConsoleLogger$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                this.javaLogger.finest(msg);
                break;
            }
            case 2: {
                this.javaLogger.fine(msg);
                break;
            }
            case 3: {
                this.javaLogger.info(msg);
                break;
            }
            case 4: {
                this.javaLogger.warning(msg);
                break;
            }
            case 5: {
                this.javaLogger.severe(msg);
                break;
            }
            case 6: {
                this.javaLogger.severe(msg);
            }
        }
    }

    private final String getStackTraceString(@NotNull Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        return string;
    }

    private final String getTraceTag(StackTraceElement trace) {
        String string = trace.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trace.className");
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
        return className + '.' + trace.getMethodName();
    }

    public ConsoleLogger() {
        java.util.logging.Logger logger;
        java.util.logging.Logger logger2 = java.util.logging.Logger.getLogger(ConsoleLogger.class.getName());
        ConsoleLogger consoleLogger = this;
        boolean bl = false;
        boolean bl2 = false;
        java.util.logging.Logger $this$apply = logger2;
        boolean bl3 = false;
        $this$apply.setLevel(Level.ALL);
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %5$s %n");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        java.util.logging.Logger logger3 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        ConsoleHandler $this$apply2 = consoleHandler;
        boolean bl6 = false;
        $this$apply2.setLevel(Level.ALL);
        $this$apply2.setFormatter(new SimpleFormatter());
        ConsoleHandler consoleHandler2 = consoleHandler;
        logger3.addHandler(consoleHandler2);
        $this$apply.setUseParentHandlers(false);
        consoleLogger.javaLogger = logger = logger2;
        this.levelMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)Log.Level.Verbose), (Object)(Logger.AnsiColor.White.getValue() + "Verbose" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Debug), (Object)(Logger.AnsiColor.Blue.getValue() + "Debug" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Info), (Object)(Logger.AnsiColor.Green.getValue() + "Info" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Warning), (Object)(Logger.AnsiColor.Yellow.getValue() + "Warn" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Error), (Object)(Logger.AnsiColor.Red.getValue() + "Error" + Logger.AnsiColor.Reset.getValue())), TuplesKt.to((Object)((Object)Log.Level.Assert), (Object)(Logger.AnsiColor.Magenta.getValue() + "Assert" + Logger.AnsiColor.Reset.getValue()))});
    }
}

