/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils.sql;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import wj.run.commons.utils.sql.ConditionWhere;

public class ConditionUtil {
    List<ConditionWhere> conds = Lists.newArrayList();
    private String limit;
    private String orderBy;

    public static ConditionUtil insT() {
        return new ConditionUtil();
    }

    public static void main(String[] args) {
        System.out.println(ConditionUtil.insT().where("key", "value").toString());
        System.out.println(ConditionUtil.insT().where("key", "like", "value", "and").toString());
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        try {
            if (obj instanceof CharSequence) {
                CharSequence cs = (CharSequence)obj;
                return StringUtils.isEmpty((CharSequence)cs.toString().trim());
            }
            if (obj instanceof Collection) {
                return CollectionUtils.isEmpty((Collection)((Collection)obj));
            }
            if (obj instanceof Map) {
                return MapUtils.isEmpty((Map)((Map)obj));
            }
            if (obj.getClass().isArray()) {
                return ArrayUtils.getLength((Object)obj) <= 0;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public List<ConditionWhere> getConds() {
        return this.conds;
    }

    public ConditionUtil where(ConditionWhere cond) {
        if (cond != null) {
            this.conds.add(cond);
        }
        return this;
    }

    public ConditionUtil where(String k, String v) {
        if (ConditionUtil.isEmpty(k) || ConditionUtil.isEmpty(v)) {
            return this;
        }
        this.conds.add(ConditionWhere.insT().k(k).v(v));
        return this;
    }

    public ConditionUtil where(String k, String link, String v, String logic) {
        this.conds.add(ConditionWhere.insT().k(k).setLink(link).v(v).setLogic(logic));
        return this;
    }

    public String toStr() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getConds().size(); ++i) {
            ConditionWhere cond = this.getConds().get(i);
            if (i > 0) {
                sb.append(cond.getLogic());
            }
            sb.append(cond.getKey());
            if (!StringUtils.isBlank((CharSequence)cond.getLink())) {
                sb.append(cond.getLink());
            }
            if (StringUtils.isBlank((CharSequence)cond.getValue())) continue;
            sb.append(cond.getValue());
        }
        if (!StringUtils.isBlank((CharSequence)this.getOrderBy())) {
            sb.append(" order by " + this.getOrderBy());
        }
        if (!StringUtils.isBlank((CharSequence)this.getLimit())) {
            sb.append(" limit " + this.getLimit());
        }
        if (this.conds.size() > 0) {
            return " where " + sb.toString();
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStr();
    }
}

