/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import wj.run.commons.utils.service.Processor;
import wj.run.commons.utils.service.ProcessorMap;

public class ServiceUtils {
    private ServiceUtils() {
    }

    public static <E> List<E> querySeparate(Set<String> ids, Processor<E> processor) {
        int i;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList();
        }
        int pageSize = 20;
        ArrayList<E> models = new ArrayList<E>();
        HashSet<Integer> pages = new HashSet<Integer>();
        for (i = 0; i < ids.size(); ++i) {
            pages.add((int)Math.floor(i / pageSize) + 1);
        }
        for (i = 0; i < pages.size(); ++i) {
            String tids = ids.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.joining(","));
            List<E> def = processor.def(tids);
            if (CollectionUtils.isEmpty(def)) {
                def = new ArrayList();
            }
            models.addAll(def);
        }
        return models;
    }

    public static <E> List<E> querySeparateInteger(Set<Integer> ids, Processor<E> processor) {
        HashSet<String> convert = new HashSet<String>();
        for (Integer id : ids) {
            if (id == null) continue;
            convert.add(String.valueOf(id));
        }
        return ServiceUtils.querySeparate(convert, processor);
    }

    public static <E> List<E> querySeparateLong(Set<Long> ids, Processor<E> processor) {
        HashSet<String> convert = new HashSet<String>();
        for (Long id : ids) {
            if (id == null) continue;
            convert.add(String.valueOf(id));
        }
        return ServiceUtils.querySeparate(convert, processor);
    }

    public static <E> List<E> querySeparate(String ids, Processor<E> processor) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return new ArrayList();
        }
        String[] spIds = StringUtils.split((String)ids, (String)",");
        Set<String> idsT = Arrays.stream(spIds).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(idsT)) {
            return new ArrayList();
        }
        return ServiceUtils.querySeparate(idsT, processor);
    }

    public static <E extends Map<String, Object>> List<Map<String, Object>> querySeparateMap(Set<String> ids, ProcessorMap<E> processor) {
        int i;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Map<String, Object>>();
        }
        int pageSize = 20;
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        HashSet<Integer> pages = new HashSet<Integer>();
        for (i = 0; i < ids.size(); ++i) {
            pages.add((int)Math.floor(i / pageSize) + 1);
        }
        for (i = 0; i < pages.size(); ++i) {
            String tids = ids.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.joining(","));
            List<Map<String, Object>> def = processor.def(tids);
            if (CollectionUtils.isEmpty(def)) {
                def = new ArrayList<Map<String, Object>>();
            }
            models.addAll(def);
        }
        return models;
    }

    public static <E extends Map<String, Object>> List<Map<String, Object>> querySeparateMap(String ids, ProcessorMap<E> processor) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return new ArrayList<Map<String, Object>>();
        }
        String[] spIds = StringUtils.split((String)ids, (String)",");
        Set<String> idsT = Arrays.stream(spIds).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(idsT)) {
            return new ArrayList<Map<String, Object>>();
        }
        return ServiceUtils.querySeparateMap(idsT, processor);
    }
}

