/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import wj.run.commons.utils.ObjectUtils;

public class JsonUtils {
    private static final Logger log = Logger.getLogger(JsonUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) {
        int i = 0;
        int j = 5;
        ++i;
        while (i <= --j) {
        }
    }

    private static void setMapperConfig() {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static void test(Object ... aaa) {
    }

    public static <T> ArrayList<T> toList(String jsonStr, Class<T> elementType) {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return new ArrayList();
        }
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, elementType);
        try {
            return (ArrayList)mapper.readValue(jsonStr, (JavaType)listType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public static <T> ArrayList<T> toList(Object map, Class<T> elementType) {
        JsonUtils.setMapperConfig();
        String jsonStr = JsonUtils.tojSON(map);
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return new ArrayList();
        }
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, elementType);
        try {
            return (ArrayList)mapper.readValue(jsonStr, (JavaType)listType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return new ArrayList();
        }
    }

    public static <T> ArrayList<T> toListError(String jsonStr, Class<T> elementType) throws Exception {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return new ArrayList();
        }
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, elementType);
        try {
            return (ArrayList)mapper.readValue(jsonStr, (JavaType)listType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
    }

    public static <K, V> HashMap<K, V> toMap(String jsonStr, Class<K> key, Class<V> value) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return new HashMap();
        }
        MapType mapType = mapper.getTypeFactory().constructMapType(HashMap.class, key, value);
        try {
            return (HashMap)mapper.readValue(jsonStr, (JavaType)mapType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return new HashMap();
        }
    }

    public static <T> T toObj(String jsonStr, Class<T> parametrized) {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        JavaType stringType = mapper.constructType(parametrized);
        try {
            return (T)mapper.readValue(jsonStr, stringType);
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    public static <T> T toObj(Object map, Class<T> parametrized) {
        JsonUtils.setMapperConfig();
        String jsonStr = JsonUtils.tojSON(map);
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        JavaType stringType = mapper.constructType(parametrized);
        try {
            return (T)mapper.readValue(jsonStr, stringType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObj(String jsonStr, Class<T> ... elementType) {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        JavaType listType = mapper.getTypeFactory().constructParametricType(ArrayList.class, (Class[])elementType);
        try {
            return (T)mapper.readValue(jsonStr, listType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static <T> T toObj(String jsonStr, TypeReference typeReference) {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonStr, typeReference);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static <T> T toObjDef(String jsonStr, Class<T> parametrized) {
        T t = null;
        try {
            t = parametrized.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return t;
        }
        JavaType stringType = mapper.constructType(parametrized);
        try {
            return (T)mapper.readValue(jsonStr, stringType);
        }
        catch (IOException e) {
            log.error((Object)e);
            return t;
        }
    }

    public static <T> T toObjError(String jsonStr, Class<T> parametrized) throws Exception {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        JavaType stringType = mapper.constructType(parametrized);
        try {
            return (T)mapper.readValue(jsonStr, stringType);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static <T> HashSet<T> toSet(String jsonStr, Class<T> elementType) {
        JsonUtils.setMapperConfig();
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return new HashSet();
        }
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(HashSet.class, elementType);
        try {
            return (HashSet)mapper.readValue(jsonStr, (JavaType)listType);
        }
        catch (IOException e) {
            log.error((Object)"\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return new HashSet();
        }
    }

    public static String tojSON(Object obj) {
        JsonUtils.setMapperConfig();
        if (ObjectUtils.isEmpty(obj)) {
            return "";
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
            return "";
        }
    }
}

