/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtils {
    static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static long currentTimeMillis() {
        return Instant.now().toEpochMilli();
    }

    public static Date getCurrentTimeToDate() {
        return new Date();
    }

    public static long customTimeMillisByMinute(int minute) {
        return Instant.now().plus((long)minute, ChronoUnit.MINUTES).toEpochMilli();
    }

    public static long customTimeMillisByDays(int days) {
        return Instant.now().plus((long)days, ChronoUnit.DAYS).toEpochMilli();
    }

    public static long getNowStartTime() {
        return Instant.now().toEpochMilli() / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
    }

    public static long getNowStartTime(long millis) {
        return millis / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
    }

    public static long getNowEndTime(long millis) {
        long nowStartTime = TimeUtils.getNowStartTime(millis);
        return nowStartTime + 86400000L - 1L;
    }

    public static long getNowEndTime() {
        long nowStartTime = TimeUtils.getNowStartTime();
        return nowStartTime + 86400000L - 1L;
    }

    public static int betweenDays(long targetTime) {
        return Period.between(LocalDate.now(), Instant.ofEpochMilli(targetTime).atZone(ZoneId.systemDefault()).toLocalDate()).getDays();
    }

    public static int betweenDays(long startTime, long endTime) {
        return Period.between(Instant.ofEpochMilli(startTime).atZone(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(endTime).atZone(ZoneId.systemDefault()).toLocalDate()).getDays();
    }

    public static String convertTimeToString(long time) {
        return dtf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
    }

    public static Long convertTimeToLong(String time) {
        LocalDateTime parse = LocalDateTime.parse(time, dtf);
        return LocalDateTime.from(parse).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static String format(long time) {
        return dtf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
    }

    public static String getNowToDaysLater(long nowTime, int day) {
        return String.valueOf(nowTime + (long)(86400000 * day));
    }

    public static String getNowPriorTo(long nowTime, int day) {
        return String.valueOf(nowTime - (long)(86400000 * day));
    }

    public static long getWeekStartMillisecond() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        currentDate.set(7, 2);
        return currentDate.getTime().toInstant().toEpochMilli();
    }

    public static long getWeekEndMillisecond() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(11, 23);
        currentDate.set(12, 59);
        currentDate.set(13, 59);
        currentDate.set(7, 1);
        return currentDate.getTime().toInstant().toEpochMilli();
    }

    public static String getNowToDiyTimeDifference(Integer year, Integer month, Integer day) {
        LocalDate localDate = LocalDate.of((int)year, month, (int)day);
        Period period = Period.between(LocalDate.now(), localDate);
        return period.getYears() + "\u5e74" + period.getMonths() + "\u4e2a\u6708";
    }

    public static Date strToDate(String str, String fmt) {
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        Date date2 = null;
        try {
            date2 = format.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date2;
    }

    public static Long getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Long getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(10, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }
}

