/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import wj.run.commons.utils.ObjectUtils;

public class ResponseUtil {
    public static ResponseEntity<byte[]> fileDownload(InputStream in, String fileFullName) {
        if (ObjectUtils.isEmpty(in)) {
            return null;
        }
        byte[] bytes = new byte[]{};
        try (InputStream tmp = in;){
            bytes = IOUtils.toByteArray((InputStream)tmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResponseEntity<byte[]> response = ResponseUtil.fileDownload(bytes, fileFullName);
        return response;
    }

    public static ResponseEntity<byte[]> fileInline(InputStream in, String fileFullName) {
        if (ObjectUtils.isEmpty(in)) {
            return null;
        }
        byte[] bytes = new byte[]{};
        try (InputStream tmp = in;){
            bytes = IOUtils.toByteArray((InputStream)tmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResponseEntity<byte[]> response = ResponseUtil.fileInline(bytes, fileFullName);
        return response;
    }

    public static ResponseEntity<byte[]> fileDownload(byte[] body, String fileFullName) {
        try {
            fileFullName = new String(fileFullName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + fileFullName);
        headers.add("Content-Length", "" + body.length);
        headers.add("Content-Type", "application/" + FilenameUtils.getExtension((String)fileFullName));
        HttpStatus statusCode = HttpStatus.OK;
        return new ResponseEntity((Object)body, (MultiValueMap)headers, statusCode);
    }

    public static ResponseEntity<byte[]> fileInline(byte[] body, String fileFullName) {
        try {
            fileFullName = new String(fileFullName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "inline;filename=" + fileFullName);
        headers.add("Content-Length", "" + body.length);
        headers.add("Content-Type", "application/" + FilenameUtils.getExtension((String)fileFullName));
        HttpStatus statusCode = HttpStatus.OK;
        return new ResponseEntity((Object)body, (MultiValueMap)headers, statusCode);
    }
}

