/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wj.run.commons.enums.QrCodeFileTypes;
import wj.run.commons.utils.TimeUtils;

public class QrCodeUtils {
    private static Logger logger = LoggerFactory.getLogger(QrCodeUtils.class);
    private static final String UTF_8 = "UTF-8";
    private static final String FILE_PATH = System.getProperty("java.io.tmpdir");
    private static final int WIDTH = 300;
    private static final int HEIGHT = 300;
    private static final String FILE_NAME = "qrCode-" + TimeUtils.currentTimeMillis();
    private static final Map<EncodeHintType, Object> encodeHintMap = Maps.newHashMap();
    private static final HashMap<DecodeHintType, Object> decodeHintMap = Maps.newHashMap();

    public static BufferedImage generateQrCodeToBufferedImage(String content, int width, int height) {
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, encodeHintMap);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (WriterException e) {
            logger.error("\u3010\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\u3011", (Object)e.getMessage());
            return null;
        }
    }

    public static BufferedImage generateQrCodeToBufferedImage(String content) {
        return QrCodeUtils.generateQrCodeToBufferedImage(content, 300, 300);
    }

    public static File generateQrCodeToFile(String content, String fileName, QrCodeFileTypes types, int width, int height) {
        QrCodeFileTypes fileTypes = Optional.ofNullable(types).orElse(QrCodeFileTypes.DEF);
        BitMatrix bitMatrix1 = QrCodeUtils.generateBitMatrix(content, width, height);
        if (bitMatrix1 == null) {
            return null;
        }
        try {
            File file = new File(FILE_PATH, fileName + "." + fileTypes.getType());
            MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix1, (String)fileTypes.getType(), (Path)file.toPath());
            return file;
        }
        catch (IOException e) {
            logger.error("\u3010\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\u3011", (Object)e.getMessage());
            return null;
        }
    }

    public static File generateQrCodeToFile(String content) {
        return QrCodeUtils.generateQrCodeToFile(content, FILE_NAME, QrCodeFileTypes.PNG, 300, 300);
    }

    public static File generateQrCodeToFile(String content, String fileName) {
        return QrCodeUtils.generateQrCodeToFile(content, fileName, QrCodeFileTypes.PNG, 300, 300);
    }

    public static void generateQrCodeToStream(String content, String fileName, QrCodeFileTypes types, int width, int height, OutputStream stream) {
        QrCodeFileTypes fileTypes = Optional.ofNullable(types).orElse(QrCodeFileTypes.PNG);
        BitMatrix bitMatrix1 = QrCodeUtils.generateBitMatrix(content, width, height);
        if (bitMatrix1 == null) {
            return;
        }
        try {
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix1, (String)(fileName + "." + fileTypes.getType()), (OutputStream)stream);
        }
        catch (IOException e) {
            logger.error("\u3010\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\u3011", (Object)e.getMessage());
        }
    }

    public static void generateQrCodeToStream(String content, String fileName, OutputStream stream) {
        QrCodeUtils.generateQrCodeToStream(content, fileName, QrCodeFileTypes.PNG, 300, 300, stream);
    }

    public static void generateQrCodeToStream(String content, OutputStream stream) {
        QrCodeUtils.generateQrCodeToStream(content, FILE_NAME, stream);
    }

    private static BitMatrix generateBitMatrix(String content, int width, int height) {
        try {
            return new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, encodeHintMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Result readQrCode(File file) {
        if (file == null) {
            return null;
        }
        try {
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            BufferedImage image = ImageIO.read(file);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
            return multiFormatReader.decode(binaryBitmap, decodeHintMap);
        }
        catch (Exception e) {
            logger.error("\u3010\u8bfb\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25\u3011", (Object)e.getMessage());
            return null;
        }
    }

    static {
        encodeHintMap.put(EncodeHintType.CHARACTER_SET, UTF_8);
        encodeHintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        encodeHintMap.put(EncodeHintType.MARGIN, 2);
        decodeHintMap.put(DecodeHintType.CHARACTER_SET, UTF_8);
    }
}

