/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import com.alibaba.druid.sql.visitor.functions.Char;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wj.run.commons.utils.json.JsonUtils;

public class ObjectUtils
extends org.apache.commons.lang3.ObjectUtils {
    private static Logger log = LoggerFactory.getLogger(ObjectUtils.class);

    private static Object _objectToMap(Object obj, Map<String, Set<String>> mapFields, boolean isTrue) {
        HashMap map = Maps.newHashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        ObjectUtils.getFields(obj.getClass(), fields);
        Set<String> fieldRetain = mapFields.get(obj.getClass().getName());
        for (Field field : fields) {
            if (isTrue && fieldRetain != null ? !fieldRetain.contains(ObjectUtils.getFieldName(field)) : fieldRetain != null && fieldRetain.contains(ObjectUtils.getFieldName(field))) continue;
            field.setAccessible(true);
            try {
                Object child;
                boolean isList = Iterable.class.isAssignableFrom(field.getType());
                try {
                    Method readMethod = PropertyUtils.getPropertyDescriptor((Object)obj, (String)field.getName()).getReadMethod();
                    child = readMethod.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.warn(field.getName() + "\u6ca1\u6709get\u65b9\u6cd5");
                    child = field.get(obj);
                }
                if (isList) {
                    Iterable childs = (Iterable)field.get(obj);
                    ArrayList temp = Lists.newArrayList();
                    Iterator iterator = childs.iterator();
                    while (iterator.hasNext()) {
                        Object o1 = ObjectUtils._objectToMap(iterator.next(), mapFields, isTrue);
                        temp.add(o1);
                    }
                    child = temp;
                } else if (child != null && mapFields.containsKey(field.getType().getName())) {
                    child = ObjectUtils._objectToMap(child, mapFields, isTrue);
                }
                map.put(field.getName(), child);
            }
            catch (Exception e) {
                log.error("\u9012\u5f52\u8f6cmap\u5f02\u5e38", (Throwable)e);
                return new Object();
            }
        }
        return map;
    }

    private static Object conversionValue(Field f, Object value) {
        if (f.getType() == value.getClass()) {
            return value;
        }
        if (f.getType() == String.class) {
            return value.toString();
        }
        if (f.getType() == BigDecimal.class) {
            return ObjectUtils.toBigDecimal(value);
        }
        if (f.getType() == Long.class) {
            return ObjectUtils.toLong(value);
        }
        if (f.getType() == Boolean.class) {
            return ObjectUtils.toBool(value);
        }
        return value;
    }

    public static <T> T copyProperties(Class<T> cla, Object obj) {
        if (ObjectUtils.isEmpty(cla) || ObjectUtils.isEmpty(obj)) {
            return null;
        }
        T t = null;
        try {
            t = cla.newInstance();
            PropertyUtils.copyProperties(t, (Object)obj);
        }
        catch (Exception e) {
            log.error("toVo\u5931\u8d25\uff01" + e.getLocalizedMessage());
        }
        return t;
    }

    public static void copyProperties(Object out, Object in) {
        if (ObjectUtils.isEmpty(out) || ObjectUtils.isEmpty(in)) {
            return;
        }
        try {
            PropertyUtils.copyProperties((Object)out, (Object)in);
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25!" + e.getLocalizedMessage());
        }
    }

    public static <T> List<T> copyPropertiesFromList(Class<T> cla, List objs) {
        ArrayList list = Lists.newArrayList();
        if (ObjectUtils.isEmpty(cla) || ObjectUtils.isEmpty(objs)) {
            return list;
        }
        for (Object obj : objs) {
            list.add(ObjectUtils.copyProperties(cla, obj));
        }
        return list;
    }

    private static String getFieldName(Field field) {
        return field.getName().substring(field.getName().lastIndexOf(".") + 1);
    }

    private static void getFields(Class<?> t, List<Field> fields) {
        Field[] declaredFields;
        for (Field field : declaredFields = t.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        Class<?> superclass = t.getSuperclass();
        if (superclass == null) {
            return;
        }
        ObjectUtils.getFields(superclass, fields);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        try {
            if (obj instanceof CharSequence) {
                CharSequence cs = (CharSequence)obj;
                return StringUtils.isEmpty((CharSequence)cs.toString().trim()) || obj.equals("null");
            }
            if (obj instanceof Collection) {
                return CollectionUtils.isEmpty((Collection)((Collection)obj));
            }
            if (obj instanceof Map) {
                return MapUtils.isEmpty((Map)((Map)obj));
            }
            if (obj.getClass().isArray()) {
                return ArrayUtils.getLength((Object)obj) <= 0;
            }
        }
        catch (Exception e) {
            log.error("\u975e\u7a7a\u5224\u65ad\u5f02\u5e38\uff01");
            return true;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        return StringUtils.isNumeric((CharSequence)str);
    }

    public static boolean isValidChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return true;
        }
        return Character.isLetterOrDigit(c);
    }

    public static void main(String[] args) {
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> beanClass) {
        Object obj = null;
        try {
            obj = beanClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        try {
            Field[] fields;
            if (map == null) {
                return (T)obj;
            }
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                Object value = map.get(field.getName());
                if (value == null) continue;
                if (map instanceof MultiValueMap) {
                    value = ((LinkedList)value).get(0);
                }
                field.set(obj, ObjectUtils.conversionValue(field, value));
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            log.warn("\u901a\u8fc7json\u4e2d\u8f6c\u4e00\u4e0b");
            obj = JsonUtils.toObjDef(JsonUtils.tojSON(map), beanClass);
            return (T)obj;
        }
        return (T)obj;
    }

    public static <T> T mergeBean(Class<T> t, Object ... e) {
        T o = null;
        try {
            o = t.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e1) {
            e1.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object temp : e) {
            map.putAll(ObjectUtils.objectToMap(temp));
        }
        o = ObjectUtils.mapToObject(map, t);
        return o;
    }

    public static Object objectOfString(Class<?> cls, String val) {
        if (cls == null || StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.parseInt(val);
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.parseByte(val);
        }
        if (cls == Character.TYPE || cls == Char.class) {
            return Character.valueOf(val.toCharArray()[0]);
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.parseShort(val);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.parseLong(val);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.parseDouble(val);
        }
        if (cls == BigDecimal.class) {
            return BigDecimal.valueOf(Double.parseDouble(val));
        }
        return null;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        return ObjectUtils.objectToMap(obj, null, null, null, null);
    }

    public static Map<String, Object> objectToMap(Object obj, Set<String> fields, boolean isTrue) {
        if (!isTrue) {
            return ObjectUtils.objectToMap(obj, null, fields, null, null);
        }
        return ObjectUtils.objectToMap(obj, fields, null, null, null);
    }

    public static Map<String, Object> objectToMap(Object obj, String[] fields, boolean isTrue) {
        if (!isTrue) {
            return ObjectUtils.objectToMap(obj, null, Arrays.stream(fields).collect(Collectors.toSet()), null, null);
        }
        return ObjectUtils.objectToMap(obj, Arrays.stream(fields).collect(Collectors.toSet()), null, null, null);
    }

    private static Map<String, Object> objectToMap(Object obj, Map<String, Set<String>> fields, boolean isTrue) {
        if (isTrue) {
            return ObjectUtils.objectToMap(obj, null, null, fields, true);
        }
        return ObjectUtils.objectToMap(obj, null, null, fields, false);
    }

    public static Map<String, Object> objectToMap(Object obj, String[] retain) {
        return ObjectUtils.objectToMap(obj, Arrays.stream(retain).collect(Collectors.toSet()), null, null, null);
    }

    public static Map<String, Object> objectToMap(Object obj, Set<String> retain) {
        return ObjectUtils.objectToMap(obj, retain, null, null, null);
    }

    private static Map<String, Object> objectToMap(Object obj, Set<String> retain, Set<String> retainNot, Map<String, Set<String>> fieldsMap, Boolean isTrue) {
        HashMap<String, Object> def = new HashMap<String, Object>();
        if (obj == null) {
            return def;
        }
        if (isTrue != null) {
            return (Map)ObjectUtils._objectToMap(obj, fieldsMap, isTrue);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ObjectUtils.getFields(obj.getClass(), fields);
        for (Field field : fields) {
            if (field.getName().equals("serialVersionUID") || retain != null && !retain.contains(field.getName()) || retainNot != null && retainNot.contains(field.getName())) continue;
            field.setAccessible(true);
            try {
                Object value;
                try {
                    Method readMethod = PropertyUtils.getPropertyDescriptor((Object)obj, (String)field.getName()).getReadMethod();
                    value = readMethod.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    log.warn(field.getName() + "\u6ca1\u6709get\u65b9\u6cd5");
                    value = field.get(obj);
                }
                map.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                log.warn("\u8f6cmap\u5f02\u5e38", (Throwable)e);
                return def;
            }
        }
        return map;
    }

    public static String[] split(String str) {
        String[] def = new String[]{};
        StringBuilder sb = new StringBuilder();
        if (ObjectUtils.isEmpty(str)) {
            return def;
        }
        for (char c : str.toCharArray()) {
            if (ObjectUtils.isValidChar(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0 || sb.codePointAt(sb.length() - 1) == "-".codePointAt(0)) continue;
            sb.append("-");
        }
        def = sb.toString().split("-");
        return def;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return ObjectUtils.toBigDecimal(obj, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(Object obj, BigDecimal def) {
        if (obj == null) {
            return def;
        }
        try {
            def = obj instanceof BigDecimal ? (BigDecimal)obj : (obj instanceof Double ? BigDecimal.valueOf((Double)obj) : (obj instanceof Integer ? BigDecimal.valueOf(((Integer)obj).intValue()) : (obj instanceof Long ? BigDecimal.valueOf((Long)obj) : (obj instanceof Float ? BigDecimal.valueOf(((Float)obj).floatValue()) : NumberUtils.createBigDecimal((String)obj.toString())))));
        }
        catch (Exception e) {
            log.warn("toBigDecimal \u8f6c\u6362\u5931\u8d25 -> " + obj.toString());
            return def;
        }
        return def;
    }

    public static boolean toBool(Object aTrue) {
        try {
            return BooleanUtils.toBoolean((String)String.valueOf(aTrue));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean toBool(Object aTrue, boolean def) {
        try {
            return BooleanUtils.toBoolean((String)String.valueOf(aTrue));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int toInt(Object obj) {
        return ObjectUtils.toInt(obj, 0);
    }

    public static int toInt(Object obj, int def) {
        if (obj == null) {
            return def;
        }
        try {
            def = obj instanceof Integer ? (Integer)obj : (obj instanceof Long ? ((Long)obj).intValue() : (obj instanceof Short ? ((Short)obj).intValue() : (obj instanceof BigDecimal ? ((BigDecimal)obj).intValue() : (obj instanceof Double ? ((Double)obj).intValue() : (obj instanceof Float ? ((Float)obj).intValue() : NumberUtils.toInt((String)obj.toString(), (int)def))))));
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5f02\u5e38\uff01" + e.getLocalizedMessage());
            return def;
        }
        return def;
    }

    public static Long toLong(Object obj) {
        return ObjectUtils.toLong(obj, 0L);
    }

    public static long toLong(Object obj, long def) {
        if (obj == null) {
            return def;
        }
        try {
            if (obj instanceof Integer) {
                def = ((Integer)obj).longValue();
            } else if (obj instanceof Long) {
                def = (Long)obj;
            } else if (obj instanceof Short) {
                def = ((Short)obj).longValue();
            } else if (obj instanceof BigDecimal) {
                def = ((BigDecimal)obj).longValue();
            } else if (obj instanceof Double) {
                def = ((Double)obj).longValue();
            } else if (obj instanceof Float) {
                def = ((Float)obj).longValue();
            } else {
                def = NumberUtils.toLong((String)obj.toString(), (long)def);
                NumberUtils.toLong((String)"");
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5f02\u5e38\uff01" + e.getLocalizedMessage());
            return def;
        }
        return def;
    }

    public static Map<String, Object> toMapFilter(Object obj, Map<String, String[]> fields, boolean isTrue) {
        HashMap temp = Maps.newHashMap();
        for (Map.Entry<String, String[]> entry : fields.entrySet()) {
            temp.put(entry.getKey(), Arrays.stream((Object[])entry.getValue()).collect(Collectors.toSet()));
        }
        return ObjectUtils.objectToMap(obj, temp, isTrue);
    }
}

