/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MailUtil {
    private static final String CHAR_SET = "UTF-8";
    private static final String TYPE = "text/html;charset=UTF-8";
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private final Logger log = LoggerFactory.getLogger(MailUtil.class);
    private String host;
    private String post;
    private String smtp;

    public MailUtil() {
        this.smtp = "smtp";
        this.host = "smtp.qq.com";
        this.post = "465";
    }

    public MailUtil(String smtp, String host, String post) {
        this.smtp = smtp;
        this.host = host;
        this.post = post;
    }

    private static MimeMessage getMimeMessage(Session session, String sendToAddress, String subject, String content) throws Exception {
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(sendToAddress));
        msg.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(sendToAddress));
        msg.setSubject(subject, CHAR_SET);
        msg.setContent((Object)content, TYPE);
        msg.setSentDate(new Date());
        return msg;
    }

    private static Session getSendSSLSession(String smtp, String host, String port) {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", smtp);
        props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.port", port);
        props.setProperty("mail.smtp.socketFactory.port", port);
        props.setProperty("mail.smtp.host", host);
        return Session.getInstance((Properties)props);
    }

    public void sendMail(String protocol, String host, String port, String from, String password, String to, String subject, String content) {
        try {
            Session session = MailUtil.getSendSSLSession(protocol, host, port);
            MimeMessage msg = MailUtil.getMimeMessage(session, to, subject, content);
            msg.setFrom(from);
            Transport transport = session.getTransport();
            transport.connect(from, password);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            this.log.error("\u3010\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\u3011,{}", (Object)e.getMessage());
        }
    }

    public void sendMail(String from, String password, String to, String subject, String content) {
        this.sendMail(this.smtp, this.host, this.post, from, password, to, subject, content);
    }
}

