/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.utils;

import java.math.BigDecimal;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.springframework.context.i18n.LocaleContextHolder;
import wj.run.commons.utils.ObjectUtils;

public class DateUtils {
    public static String fmt(Long epochMilli, String fmtPattern) {
        if (epochMilli == null) {
            epochMilli = Instant.now().toEpochMilli();
        }
        if (fmtPattern == null) {
            fmtPattern = "yyyy-MM-dd HH:mm";
        }
        Instant instant = Instant.ofEpochMilli(epochMilli);
        Locale locale = LocaleContextHolder.getLocale();
        ZoneId zoneId = new GregorianCalendar(locale).getTimeZone().toZoneId();
        return LocalDateTime.ofInstant(instant, zoneId).format(DateTimeFormatter.ofPattern(fmtPattern));
    }

    public static String fmt(Long epochMilli) {
        return DateUtils.fmt(epochMilli, null);
    }

    public static String fmtDate(Long epochMilli) {
        return DateUtils.fmt(epochMilli, "yyyy-MM-dd");
    }

    public static void main(String[] args) {
        LocalDate now = LocalDate.now(Clock.systemUTC());
        long toEpochDay = now.minusDays(3L).toEpochDay();
        System.out.println(toEpochDay);
        System.out.println(BigDecimal.valueOf(toEpochDay).divide(BigDecimal.valueOf(7L), 0, 0));
    }

    public static long toEpochDay() {
        return LocalDate.now(Clock.systemUTC()).toEpochDay();
    }

    public static Long toEpochMilli() {
        return Instant.now().toEpochMilli();
    }

    public static Long toEpochSecond() {
        return Instant.now().getEpochSecond();
    }

    public static Long toEpochMonthly() {
        LocalDate now = LocalDate.now(Clock.systemUTC());
        return ObjectUtils.toLong(now.getYear() + now.getMonthValue());
    }

    public static Long toEpochWeek() {
        LocalDate now = LocalDate.now(Clock.systemUTC());
        long toEpochDay = now.minusDays(3L).toEpochDay();
        int intValue = BigDecimal.valueOf(toEpochDay).divide(BigDecimal.valueOf(7L), 0, 0).intValue();
        return intValue;
    }

    public static String getTimeFmt(Long time) {
        if (time == null) {
            return "00:00:00";
        }
        long hours = TimeUnit.SECONDS.toHours(time);
        long minutes = TimeUnit.SECONDS.toMinutes(time - TimeUnit.HOURS.toSeconds(hours));
        long seconds = time - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.MINUTES.toSeconds(minutes);
        return hours + ":" + minutes + ":" + seconds;
    }

    public static String fmtOnline(Long toEpochMilli) {
        long minutes;
        long jl = DateUtils.toEpochMilli() - toEpochMilli;
        if (jl <= (minutes = TimeUnit.MINUTES.toMillis(1L))) {
            return "1 minute ago";
        }
        long hours = TimeUnit.HOURS.toMillis(1L);
        if (jl <= hours) {
            return jl / minutes + " hours ago";
        }
        long day = TimeUnit.DAYS.toMillis(1L);
        if (jl <= day) {
            return jl / hours + " day ago";
        }
        long week = TimeUnit.DAYS.toMillis(7L);
        if (jl <= week) {
            return jl / week + " week ago";
        }
        long year = TimeUnit.DAYS.toMillis(30L);
        if (jl <= year) {
            return jl / year + " year ago";
        }
        return "many years ago";
    }
}

