/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.spring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import wj.run.commons.spring.annotation.RequestBodyExt;
import wj.run.commons.utils.ObjectUtils;

public class RequestResponseBodyMethodExtProcessor
implements HandlerMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(RequestResponseBodyMethodExtProcessor.class);
    private RequestResponseBodyMethodProcessor requestResponseBodyMethodProcessor;

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        ArrayList list = Lists.newArrayList();
        list.add(new MappingJackson2HttpMessageConverter());
        this.requestResponseBodyMethodProcessor = new RequestResponseBodyMethodProcessor((List)list);
        Object object = this.requestResponseBodyMethodProcessor.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (object == null) {
            try {
                object = parameter.getParameterType().newInstance();
            }
            catch (Exception e) {
                object = Maps.newLinkedHashMap();
            }
        }
        if (object instanceof LinkedHashMap) {
            Iterator names = webRequest.getParameterNames();
            while (names.hasNext()) {
                String key = (String)names.next();
                String s = webRequest.getParameter(key);
                if (StringUtils.isBlank((CharSequence)s)) continue;
                ((Map)object).put(key, s);
            }
        } else {
            Iterator names = webRequest.getParameterNames();
            while (names.hasNext()) {
                String key = (String)names.next();
                String value = webRequest.getParameter(key);
                if (StringUtils.isBlank((CharSequence)value) || !PropertyUtils.isWriteable((Object)object, (String)key)) continue;
                try {
                    Class type = PropertyUtils.getPropertyType((Object)object, (String)key);
                    PropertyUtils.setProperty((Object)object, (String)key, (Object)ObjectUtils.objectOfString(type, value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return object;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestBodyExt.class);
    }
}

