/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.service.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;

public abstract class ModelFieldScanService {
    protected List<String> skipField = new ArrayList<String>();
    protected List<String> skipRegulars = new ArrayList<String>();

    public Map<String, Map<String, String>> loadFields(ApplicationContext context) {
        return this.scanModelLoadFields(context);
    }

    private Map<String, Map<String, String>> scanModelLoadFields(ApplicationContext context) {
        if (context == null) {
            return null;
        }
        this.addSkipFieldName();
        this.addSkipRegular();
        Object[] rest = context.getBeanNamesForAnnotation(this.getModelClassByAnnotation());
        if (ObjectUtils.isEmpty((Object[])rest)) {
            return null;
        }
        HashMap<String, Map<String, String>> clazzMaps = new HashMap<String, Map<String, String>>();
        for (Object clazz : rest) {
            String s = String.valueOf(clazz);
            Object o = context.getBean(s);
            Class cla = o.getClass();
            if (AopUtils.isAopProxy((Object)o)) {
                cla = AopUtils.getTargetClass((Object)o);
                if (AopUtils.isJdkDynamicProxy((Object)o)) {
                    cla = cla.getSuperclass();
                }
                while (cla.getName().contains("$$")) {
                    cla = cla.getSuperclass();
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (Field field : cla.getDeclaredFields()) {
                String fieldName = field.getName();
                if (this.needSkip(fieldName)) continue;
                String fieldDescribe = this.getFieldDescribe(field);
                map.put(fieldName, fieldDescribe);
            }
            String clazzName = cla.getSimpleName();
            clazzMaps.put(clazzName, map);
        }
        return clazzMaps;
    }

    private boolean needSkip(String fieldName) {
        if (this.skipField.contains(fieldName)) {
            return true;
        }
        for (String skipRegular : this.skipRegulars) {
            if (!fieldName.matches(skipRegular)) continue;
            return true;
        }
        return false;
    }

    protected boolean skipField(String systemRequestMapping) {
        if (this.skipField.contains(systemRequestMapping)) {
            return true;
        }
        for (String skipRegular : this.skipRegulars) {
            if (!systemRequestMapping.matches(skipRegular)) continue;
            return true;
        }
        return false;
    }

    protected void addSkipFieldName() {
        this.skipField.add("serialVersionUID");
        this.skipField.add("id");
    }

    protected void addSkipRegular() {
    }

    protected abstract String getFieldDescribe(Field var1);

    protected abstract Class<? extends Annotation> getModelClassByAnnotation();
}

