/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.service.log;

import java.lang.reflect.Field;
import java.util.Map;
import wj.run.commons.constant.OperationTypeEnum;
import wj.run.commons.constant.SystemNameEnum;
import wj.run.commons.model.CaseRes;
import wj.run.commons.model.InSystemsLogs;
import wj.run.commons.service.log.LogSave;
import wj.run.commons.service.log.LogSaveHttpUtil;
import wj.run.commons.utils.ObjectUtils;
import wj.run.commons.utils.RequestUtils;

public class LogHelperUtil {
    public static boolean saveEventLog(LogSave api, SystemNameEnum system, OperationTypeEnum operationType, long userId, String logDescription) {
        if (api == null) {
            return false;
        }
        try {
            InSystemsLogs logs = new InSystemsLogs();
            logs.setSource(system.getId());
            logs.setIp(RequestUtils.getIp());
            logs.setUserId(userId);
            logs.setType(20000);
            logs.setOperationType(operationType.getId());
            logs.setLogDescription(logDescription);
            logs.setRequestUri(system.getShortName() + RequestUtils.getUri());
            CaseRes caseRes = api.addLogInside(logs);
            return (Boolean)caseRes.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveEventLog(LogSave api, SystemNameEnum system, Integer type, OperationTypeEnum operationType, Long userId, String logDescription) {
        if (api == null) {
            return false;
        }
        try {
            InSystemsLogs logs = new InSystemsLogs();
            logs.setSource(system.getId());
            logs.setIp(RequestUtils.getIp());
            logs.setUserId(userId);
            logs.setType(type);
            logs.setOperationType(operationType.getId());
            logs.setLogDescription(logDescription);
            logs.setRequestUri(RequestUtils.getUri());
            CaseRes caseRes = api.addLogInside(logs);
            return (Boolean)caseRes.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveEventLog(LogSaveHttpUtil httpRequest, SystemNameEnum system, OperationTypeEnum operationType, long userId, String logDescription) {
        if (httpRequest == null) {
            return false;
        }
        try {
            InSystemsLogs logs = new InSystemsLogs();
            logs.setSource(system.getId());
            logs.setIp(RequestUtils.getIp());
            logs.setUserId(userId);
            logs.setType(20000);
            logs.setOperationType(operationType.getId());
            logs.setLogDescription(logDescription);
            logs.setRequestUri(system.getShortName() + RequestUtils.getUri());
            CaseRes<Boolean> caseRes = httpRequest.addLogInside(logs);
            return caseRes.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveEventLog(LogSaveHttpUtil httpRequest, int type, SystemNameEnum system, OperationTypeEnum operationType, long userId, String logDescription) {
        if (httpRequest == null) {
            return false;
        }
        try {
            InSystemsLogs logs = new InSystemsLogs();
            logs.setSource(system.getId());
            logs.setIp(RequestUtils.getIp());
            logs.setUserId(userId);
            logs.setType(type);
            logs.setOperationType(operationType.getId());
            logs.setLogDescription(logDescription);
            logs.setRequestUri(system.getShortName() + RequestUtils.getUri());
            CaseRes<Boolean> caseRes = httpRequest.addLogInside(logs);
            return caseRes.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static OperationTypeEnum getOperationTypeEnum(String methodName) {
        if (ObjectUtils.isEmpty(methodName)) {
            return OperationTypeEnum.UN_KNOW;
        }
        if (LogHelperUtil.isAddMethod(methodName)) {
            return OperationTypeEnum.ADD;
        }
        if (LogHelperUtil.isGetMethod(methodName)) {
            return OperationTypeEnum.SELECT;
        }
        if (LogHelperUtil.isUpdateMethod(methodName)) {
            return OperationTypeEnum.UPDATE;
        }
        if (LogHelperUtil.isDeleteMethod(methodName)) {
            return OperationTypeEnum.DELETE;
        }
        return OperationTypeEnum.UN_KNOW;
    }

    private static boolean isDeleteMethod(String methodName) {
        if (ObjectUtils.isEmpty(methodName)) {
            return false;
        }
        return methodName.startsWith("delete");
    }

    private static boolean isUpdateMethod(String methodName) {
        if (ObjectUtils.isEmpty(methodName)) {
            return false;
        }
        return methodName.startsWith("upd");
    }

    private static boolean isAddMethod(String methodName) {
        if (ObjectUtils.isEmpty(methodName)) {
            return false;
        }
        if (methodName.startsWith("add")) {
            return true;
        }
        return methodName.startsWith("insert");
    }

    private static boolean isGetMethod(String methodName) {
        if (ObjectUtils.isEmpty(methodName)) {
            return false;
        }
        if (methodName.startsWith("get")) {
            return true;
        }
        if (methodName.startsWith("select")) {
            return true;
        }
        if (methodName.startsWith("find")) {
            return true;
        }
        return methodName.startsWith("search");
    }

    public static String getObjectFieldDifference(Map<String, String> fieldNameDescribe, Object a, Object b) {
        if (fieldNameDescribe == null || a == null || b == null) {
            return "";
        }
        try {
            StringBuffer sb = new StringBuffer();
            for (Field nowField : a.getClass().getDeclaredFields()) {
                Field beforeField;
                nowField.setAccessible(true);
                Object now = nowField.get(a);
                if (ObjectUtils.isEmpty(now) || (beforeField = b.getClass().getDeclaredField(nowField.getName())) == null) continue;
                beforeField.setAccessible(true);
                Object before = beforeField.get(b);
                if (ObjectUtils.isEmpty(before) || before.equals(now)) continue;
                sb.append(fieldNameDescribe.get(beforeField.getName()) + ":" + before.toString() + " \u6539\u4e3a " + now.toString() + ",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

