/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.plugin.generator.util;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import wj.run.commons.utils.ObjectUtils;
import wj.run.commons.utils.StringUtils;

public class IntrospectUtil {
    public static String getColumnDefaultValue(IntrospectedColumn column) {
        if (column == null) {
            return "";
        }
        if ("Long".equalsIgnoreCase(column.getFullyQualifiedJavaType().getShortNameWithoutTypeArguments())) {
            return "System.currentTimeMillis()";
        }
        if ("Date".equalsIgnoreCase(column.getFullyQualifiedJavaType().getShortNameWithoutTypeArguments())) {
            return "new Date()";
        }
        return "";
    }

    private static IntrospectedColumn getIntrospectedColumnByColumnName(List<IntrospectedColumn> columns, String columnName) {
        if (ObjectUtils.isEmpty(columns) || ObjectUtils.isEmpty(columnName)) {
            return null;
        }
        for (IntrospectedColumn column : columns) {
            if (!column.getActualColumnName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public static IntrospectedColumn getIntrospectedColumnByColumnName(List<IntrospectedColumn> columns, String ... columnName) {
        if (ObjectUtils.isEmpty(columns) || ObjectUtils.isEmpty(columnName)) {
            return null;
        }
        for (String s : columnName) {
            IntrospectedColumn column = IntrospectUtil.getIntrospectedColumnByColumnName(columns, s);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public static String getZeroValue(IntrospectedColumn column) {
        if (column == null) {
            return "";
        }
        switch (column.getFullyQualifiedJavaType().getFullyQualifiedNameWithoutTypeParameters()) {
            case "java.lang.Long": {
                return "0L";
            }
            case "java.lang.Integer": {
                return "0";
            }
        }
        return "0";
    }

    public static String putSetMethod(String obj, IntrospectedColumn column, String value) {
        if (column == null) {
            return "";
        }
        StringBuffer setMethod = new StringBuffer();
        setMethod.append(obj);
        setMethod.append(".set" + StringUtils.getUpperCaseFirstCharacterCase(column.getJavaProperty()));
        setMethod.append("(");
        setMethod.append(value);
        setMethod.append(");");
        return setMethod.toString();
    }

    public static String putSetMethod(String obj, IntrospectedColumn column) {
        return IntrospectUtil.putSetMethod(obj, column, IntrospectUtil.getColumnDefaultValue(column));
    }
}

