/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.plugin.generator.plugins;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.AbstractJavaMapperMethodGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.sqlprovider.AbstractJavaProviderMethodGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaInModelGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaMapperSelectByConditionMethodGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaOutModelGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaRepositoryGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaServiceGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.JavaServiceImplGenerator;
import wj.run.commons.plugin.generator.codegen.mybatis.model.ProviderSelectByConditionMethodGenerator;
import wj.run.commons.utils.ObjectUtils;

public class AdditionalJavaFilePlugin
extends PluginAdapter {
    private IntrospectedTable introspectedTable;
    private List<GeneratedJavaFile> javaGenerators;

    private void addToJavaGenerators(List<CompilationUnit> units) {
        for (CompilationUnit unit : units) {
            GeneratedJavaFile gif = new GeneratedJavaFile(unit, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
            this.javaGenerators.add(gif);
        }
    }

    private void calculateClazzFullyQualifiedJavaType() {
        String outModelPackage;
        String inModelPackage;
        String serviceImplPackage;
        String serviceTypePackage;
        String repositoryPackage = this.properties.getProperty("contextPluginRepositoryTargetPackage");
        if (!ObjectUtils.isEmpty(repositoryPackage)) {
            String repositoryType = new StringBuffer(repositoryPackage).append(".").append(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName()).append("Repository").toString();
            this.context.addProperty("repositoryFullyQualifiedJavaType", repositoryType);
        }
        if (!ObjectUtils.isEmpty(serviceTypePackage = this.properties.getProperty("contextPluginServiceTargetPackage"))) {
            String serviceType = new StringBuffer(serviceTypePackage).append(".").append(this.properties.getProperty("contextPluginServiceNamePrefix")).append(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName()).append("Service").toString();
            this.context.addProperty("serviceFullyQualifiedJavaType", serviceType);
        }
        if (!ObjectUtils.isEmpty(serviceImplPackage = this.properties.getProperty("contextPluginServiceImplTargetPackage"))) {
            String serviceImpl = new StringBuffer(serviceImplPackage).append(".").append(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName()).append("Service").toString();
            this.context.addProperty("serviceImplFullyQualifiedJavaType", serviceImpl);
        }
        if (!ObjectUtils.isEmpty(inModelPackage = this.properties.getProperty("contextPluginInModelTargetPackage"))) {
            String inModel = new StringBuffer(inModelPackage).append(".").append("In").append(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName()).toString();
            this.context.addProperty("inModelFullyQualifiedJavaType", inModel);
        }
        if (!ObjectUtils.isEmpty(outModelPackage = this.properties.getProperty("contextPluginOutModelTargetPackage"))) {
            String outModel = new StringBuffer(outModelPackage).append(".").append("Out").append(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName()).toString();
            this.context.addProperty("outModelFullyQualifiedJavaType", outModel);
        }
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.init(introspectedTable);
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
        interfaze.addAnnotation("@Mapper");
        String pluginRootInterface = introspectedTable.getContext().getJavaClientGeneratorConfiguration().getProperty("pluginAnyRootInterface");
        if (!ObjectUtils.isEmpty(pluginRootInterface)) {
            String addGeneralize = pluginRootInterface + "<" + introspectedTable.getFullyQualifiedTable().getDomainObjectName() + ">";
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(addGeneralize);
            interfaze.addImportedType(fqjt);
            interfaze.addSuperInterface(new FullyQualifiedJavaType(fqjt.getShortName()));
        }
        JavaMapperSelectByConditionMethodGenerator javaMapperSelectByConditionMethodGenerator = new JavaMapperSelectByConditionMethodGenerator();
        this.initializeAndExecuteGenerator(javaMapperSelectByConditionMethodGenerator, interfaze);
        return super.clientGenerated(interfaze, topLevelClass, introspectedTable);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        this.init(introspectedTable);
        this.createRepositoryGenerators();
        this.createServiceGenerators();
        this.createServiceImplGenerators();
        this.createInModelGenerators();
        this.createOutModelGenerators();
        return this.javaGenerators;
    }

    private void createInModelGenerators() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginInModelTargetPackage"))) {
            return;
        }
        JavaInModelGenerator javaGenerator = new JavaInModelGenerator();
        this.initJavaGenerator(javaGenerator);
        this.addToJavaGenerators(javaGenerator.getCompilationUnits());
    }

    private void createOutModelGenerators() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginOutModelTargetPackage"))) {
            return;
        }
        JavaOutModelGenerator javaGenerator = new JavaOutModelGenerator();
        this.initJavaGenerator(javaGenerator);
        this.addToJavaGenerators(javaGenerator.getCompilationUnits());
    }

    private void createRepositoryGenerators() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginRepositoryTargetPackage"))) {
            return;
        }
        JavaRepositoryGenerator javaGenerator = new JavaRepositoryGenerator();
        this.initJavaGenerator(javaGenerator);
        this.addToJavaGenerators(javaGenerator.getCompilationUnits());
    }

    private void createServiceGenerators() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginServiceTargetPackage"))) {
            return;
        }
        JavaServiceGenerator javaGenerator = new JavaServiceGenerator();
        this.initJavaGenerator(javaGenerator);
        this.addToJavaGenerators(javaGenerator.getCompilationUnits());
    }

    private void createServiceImplGenerators() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginServiceTargetPackage"))) {
            return;
        }
        JavaServiceImplGenerator javaGenerator = new JavaServiceImplGenerator();
        this.initJavaGenerator(javaGenerator);
        this.addToJavaGenerators(javaGenerator.getCompilationUnits());
    }

    private void init(IntrospectedTable introspectedTable) {
        this.introspectedTable = introspectedTable;
        this.javaGenerators = new ArrayList<GeneratedJavaFile>();
        this.initDefaultProperty();
        this.calculateClazzFullyQualifiedJavaType();
    }

    private void initDefaultProperty() {
        if (ObjectUtils.isEmpty(this.properties.getProperty("contextPluginDaoNamePrefix"))) {
            this.context.addProperty("contextPluginDaoNamePrefix", "I");
        }
    }

    private void initJavaGenerator(AbstractJavaGenerator javaGenerator) {
        javaGenerator.setContext(this.context);
        javaGenerator.setIntrospectedTable(this.introspectedTable);
    }

    protected void initializeAndExecuteGenerator(AbstractJavaMapperMethodGenerator methodGenerator, Interface interfaze) {
        methodGenerator.setContext(this.context);
        methodGenerator.setIntrospectedTable(this.introspectedTable);
        methodGenerator.addInterfaceElements(interfaze);
    }

    public void initializeAndExecuteGenerator(AbstractJavaProviderMethodGenerator methodGenerator, TopLevelClass topLevelClass) {
        methodGenerator.setContext(this.context);
        methodGenerator.setIntrospectedTable(this.introspectedTable);
        methodGenerator.addClassElements(topLevelClass);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType("com.aoshu.api.annoatation.F");
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean providerGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.init(introspectedTable);
        ProviderSelectByConditionMethodGenerator selectByConditionMethodGenerator = new ProviderSelectByConditionMethodGenerator();
        this.initializeAndExecuteGenerator(selectByConditionMethodGenerator, topLevelClass);
        return super.providerGenerated(topLevelClass, introspectedTable);
    }

    public boolean validate(List<String> list) {
        return true;
    }
}

