/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.plugin.generator.codegen.mybatis.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;

public class JavaServiceImplGenerator
extends AbstractJavaGenerator {
    private FullyQualifiedJavaType serviceType;
    private FullyQualifiedJavaType fieldRepositoryType;
    private FullyQualifiedJavaType implInterfaceType;
    private FullyQualifiedJavaType repositoryType;

    private void calculateFullyQualifiedJavaType() {
        this.serviceType = new FullyQualifiedJavaType(this.context.getProperty("serviceImplFullyQualifiedJavaType"));
        this.implInterfaceType = new FullyQualifiedJavaType(this.context.getProperty("serviceFullyQualifiedJavaType"));
        this.fieldRepositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
        this.repositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
    }

    public List<CompilationUnit> getCompilationUnits() {
        this.calculateFullyQualifiedJavaType();
        TopLevelClass clazz = new TopLevelClass(this.serviceType);
        clazz.addSuperInterface(this.implInterfaceType);
        clazz.setVisibility(JavaVisibility.PUBLIC);
        clazz.addImportedType(this.introspectedTable.getBaseRecordType());
        clazz.addImportedType(this.fieldRepositoryType);
        clazz.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        clazz.addImportedType("org.springframework.stereotype.Service");
        clazz.addImportedType(this.implInterfaceType);
        clazz.addAnnotation("@Service");
        Field field = new Field();
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setType(this.fieldRepositoryType);
        field.setName(wj.run.commons.utils.StringUtils.getLowerCaseFirstCharacterCase(this.fieldRepositoryType.getShortName()));
        field.addAnnotation("@Autowired");
        clazz.addField(field);
        Method method = new Method();
        method.addAnnotation("@Override");
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("addOrUpdate");
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        method.addParameter(new Parameter(parameterType, "record"));
        String parameterName = "record";
        Field repository = new Field();
        repository.setVisibility(JavaVisibility.PRIVATE);
        repository.setType(this.repositoryType);
        String name = this.repositoryType.getShortName();
        String replaceName = StringUtils.replaceOnce((String)name, (String)this.context.getProperty("contextPluginDaoNamePrefix"), (String)"");
        String caseName = wj.run.commons.utils.StringUtils.getLowerCaseFirstCharacterCase(replaceName);
        repository.setName(caseName);
        repository.addAnnotation("@Autowired");
        clazz.addField(repository);
        method.addBodyLine("return " + repository.getName() + ".addOrUpdate(" + parameterName + ");");
        clazz.addMethod(method);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        answer.add((CompilationUnit)clazz);
        return answer;
    }
}

