/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.plugin.generator.codegen.mybatis.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import wj.run.commons.plugin.generator.util.IntrospectUtil;
import wj.run.commons.utils.ObjectUtils;

public class JavaRepositoryGenerator4
extends AbstractJavaGenerator {
    private FullyQualifiedJavaType repositoryType;
    private FullyQualifiedJavaType dao;
    private FullyQualifiedJavaType model;
    private FullyQualifiedJavaType inModel;
    private FullyQualifiedJavaType listModel;
    private IntrospectedColumn createTime;
    private IntrospectedColumn updateTime;
    private IntrospectedColumn wasDel;
    private IntrospectedColumn id;

    private void init() {
        this.repositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
        this.inModel = ObjectUtils.isEmpty(this.context.getProperty("inModelFullyQualifiedJavaType")) ? new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType()) : new FullyQualifiedJavaType(this.context.getProperty("inModelFullyQualifiedJavaType"));
        this.dao = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType());
        this.model = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        this.createTime = IntrospectUtil.getIntrospectedColumnByColumnName((List<IntrospectedColumn>)this.introspectedTable.getAllColumns(), "create_time", "created_time");
        this.updateTime = IntrospectUtil.getIntrospectedColumnByColumnName((List<IntrospectedColumn>)this.introspectedTable.getAllColumns(), "update_time", "updated_time");
        this.wasDel = IntrospectUtil.getIntrospectedColumnByColumnName((List<IntrospectedColumn>)this.introspectedTable.getAllColumns(), "is_del", "was_del", "is_delete");
        this.id = IntrospectUtil.getIntrospectedColumnByColumnName((List<IntrospectedColumn>)this.introspectedTable.getAllColumns(), new String[]{"id"});
    }

    public List<CompilationUnit> getCompilationUnits() {
        this.init();
        this.introspectedTable.getBaseColumns();
        TopLevelClass clazz = new TopLevelClass(this.repositoryType);
        clazz.addImportedType(this.inModel);
        clazz.addImportedType(this.model);
        clazz.addImportedType("java.util.List");
        clazz.addImportedType("java.util.ArrayList");
        clazz.setVisibility(JavaVisibility.PUBLIC);
        clazz.addImportedType(this.model);
        clazz.addImportedType(this.dao);
        clazz.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        clazz.addImportedType("org.springframework.stereotype.Repository");
        clazz.addAnnotation("@Repository");
        clazz.addAnnotation("@ChooseDataSource(DataSources.?)");
        Field dao = new Field();
        dao.setVisibility(JavaVisibility.PRIVATE);
        dao.setType(this.dao);
        String name = this.dao.getShortName();
        String replaceName = StringUtils.replaceOnce((String)name, (String)this.context.getProperty("contextPluginDaoNamePrefix"), (String)"");
        String caseName = wj.run.commons.utils.StringUtils.getLowerCaseFirstCharacterCase(replaceName);
        dao.setName(caseName);
        dao.addAnnotation("@Autowired");
        clazz.addField(dao);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        answer.add((CompilationUnit)clazz);
        return answer;
    }

    private void addSelectByCondition(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("selectByCondition");
        String parameterName = "condition";
        FullyQualifiedJavaType listType = new FullyQualifiedJavaType("List<" + this.introspectedTable.getBaseRecordType() + ">");
        method.setReturnType(listType);
        method.addParameter(new Parameter(this.inModel, parameterName));
        method.addBodyLine("if (" + parameterName + " == null){");
        method.addBodyLine("  return new ArrayList();");
        method.addBodyLine("}");
        method.addBodyLine("  return " + dao.getName() + ".selectByCondition(" + parameterName + ");");
        clazz.addMethod(method);
    }

    private void addSelectByPrimaryKey(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.setReturnType(this.model);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("selectByPrimaryKey");
        String parameterName = "id";
        method.addParameter(new Parameter(this.id.getFullyQualifiedJavaType(), parameterName));
        method.addBodyLine("if (id == null ){");
        method.addBodyLine("  return null;");
        method.addBodyLine("}");
        method.addBodyLine("  return " + dao.getName() + ".selectByPrimaryKey(" + parameterName + ");");
        clazz.addMethod(method);
    }

    private void addMethodAddOrUpd(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("addOrUpdate");
        String parameterName = "record";
        method.addParameter(new Parameter(this.model, parameterName));
        method.addBodyLine("if (" + parameterName + "==null){");
        method.addBodyLine("return 0;");
        method.addBodyLine("}");
        method.addBodyLine("");
        method.addBodyLine("if(" + parameterName + ".getId()==null ){");
        if (!ObjectUtils.isEmpty(IntrospectUtil.putSetMethod(parameterName, this.wasDel, IntrospectUtil.getZeroValue(this.wasDel)))) {
            method.addBodyLine("" + IntrospectUtil.putSetMethod(parameterName, this.wasDel, IntrospectUtil.getZeroValue(this.wasDel)));
        }
        method.addBodyLine("return " + dao.getName() + ".insert(" + parameterName + ");");
        method.addBodyLine("}else{");
        method.addBodyLine("return " + dao.getName() + ".updateByPrimaryKeySelective(" + parameterName + ");");
        method.addBodyLine("}");
        clazz.addMethod(method);
    }
}

