/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.model;

import java.time.Instant;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import wj.run.commons.model.Res;

public final class ResBuilder {
    private Object data;
    private Integer eCode;
    private String eMsg;
    private List<Object> list = Lists.newArrayList();
    private String role;
    private Boolean success;
    private Long time = Instant.now().toEpochMilli();
    private String value;

    private ResBuilder() {
    }

    public ResBuilder(List<Object> list) {
        this.list = list;
    }

    public ResBuilder(Object data) {
        this.data = data;
    }

    public ResBuilder(String eMsg) {
        this.eMsg = eMsg;
    }

    public static ResBuilder Res() {
        return new ResBuilder();
    }

    public static ResBuilder Res(Object data) {
        return new ResBuilder(data);
    }

    public static ResBuilder Res(List<Object> list) {
        return new ResBuilder(list);
    }

    public static ResBuilder Res(String eMsg) {
        return new ResBuilder(eMsg);
    }

    public Res build() {
        Res res = new Res();
        res.seteMsg(this.eMsg);
        res.setTime(this.time);
        res.setData(this.data);
        res.setList(this.list);
        res.setValue(this.value);
        res.setRole(this.role);
        res.seteCode(this.eCode);
        res.setSuccess(this.success);
        return res;
    }

    public ResBuilder data(Object data) {
        this.data = data;
        return this;
    }

    public ResBuilder eCode(Integer eCode) {
        this.eCode = eCode;
        return this;
    }

    public ResBuilder eMsg(String eMsg) {
        this.eMsg = eMsg;
        return this;
    }

    public ResBuilder list(List<Object> list) {
        this.list = list;
        return this;
    }

    public ResBuilder role(String role) {
        this.role = role;
        return this;
    }

    public ResBuilder success(Boolean success) {
        this.success = success;
        return this;
    }

    public ResBuilder time(Long time) {
        this.time = time;
        return this;
    }

    public ResBuilder value(String value) {
        this.value = value;
        return this;
    }
}

