/*
 * Decompiled with CFR 0.152.
 */
package wj.run.commons.model;

import wj.run.commons.enums.ResultStatesTypes;
import wj.run.commons.utils.TimeUtils;
import wj.run.commons.utils.json.JsonUtils;

public class CaseResult<E> {
    public long nowTime = TimeUtils.currentTimeMillis();
    private E content;
    private int failureReason = 0;
    private int resultStates = 0;

    private CaseResult() {
    }

    private static <E> CaseResult New() {
        return new CaseResult<E>();
    }

    public static CaseResult ToFailedResult(int failureReason) {
        return CaseResult.ToResult(null, ResultStatesTypes.FAILED.getIndex(), failureReason);
    }

    private static <E> CaseResult ToResult(E content, int states, Integer failureReason) {
        CaseResult caseResult = CaseResult.New();
        caseResult.setContent(content);
        caseResult.setFailureReason(failureReason);
        caseResult.setResultStates(states);
        return caseResult;
    }

    public static <E> CaseResult ToSucceededResult(E object) {
        return CaseResult.ToResult(object, ResultStatesTypes.SUCCEEDED.getIndex(), 0);
    }

    public static CaseResult ToSuccessResult() {
        return CaseResult.ToResult(null, ResultStatesTypes.SUCCEEDED.getIndex(), 0);
    }

    public E getContent() {
        return this.content;
    }

    public void setContent(E content) {
        this.content = content;
    }

    public int getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(int failureReason) {
        this.failureReason = failureReason;
    }

    public long getNowTime() {
        return this.nowTime;
    }

    public void setNowTime(long nowTime) {
        this.nowTime = nowTime;
    }

    public int getResultStates() {
        return this.resultStates;
    }

    public void setResultStates(int resultStates) {
        this.resultStates = resultStates;
    }

    public String toJson() {
        return JsonUtils.tojSON(this);
    }
}

