/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.canonicalizer;

import com.datasqrl.canonicalizer.AbstractPath;
import com.datasqrl.canonicalizer.Name;
import com.datasqrl.canonicalizer.NameCanonicalizer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class NamePath
extends AbstractPath<Name, NamePath> {
    public static final NamePath ROOT = new NamePath(new Name[0]);
    private static final Constructor CONSTRUCTOR = new Constructor();

    private NamePath(Name ... names) {
        super((Comparable[])names);
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
    }

    public static NamePath system(List<String> names) {
        return NamePath.of((String[])names.toArray(String[]::new));
    }

    protected Constructor constructor() {
        return CONSTRUCTOR;
    }

    public String getDisplay() {
        return Arrays.stream((Name[])this.elements).map(e -> e.getDisplay()).collect(Collectors.joining("."));
    }

    public Name[] getNames() {
        return (Name[])this.elements;
    }

    public List<String> toStringList() {
        return Arrays.stream((Name[])this.elements).map(n -> n.getDisplay()).collect(Collectors.toList());
    }

    public static NamePath of(Name ... names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return new NamePath(names);
    }

    public static NamePath of(@NonNull List<Name> names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return (NamePath)CONSTRUCTOR.of(names);
    }

    public static NamePath of(String ... names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return (NamePath)CONSTRUCTOR.of(Name::system, names);
    }

    public static NamePath parse(String path) {
        return (NamePath)CONSTRUCTOR.parse(path, s -> Name.of(s, NameCanonicalizer.SYSTEM));
    }

    private static final class Constructor
    extends AbstractPath.Constructor<Name, NamePath> {
        private Constructor() {
        }

        protected NamePath create(Name ... elements) {
            if (elements == null) {
                throw new NullPointerException("elements is marked non-null but is null");
            }
            return new NamePath(elements);
        }

        protected Name[] createArray(int length) {
            return new Name[length];
        }

        @Override
        protected NamePath root() {
            return ROOT;
        }
    }
}

